/*
 * Decompiled with CFR 0.152.
 */
package sim.app.cto;

import java.awt.Color;
import sim.app.cto.CooperativeObservation;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Double2D;

public class CTOAgent
extends OvalPortrayal2D
implements Steppable {
    public String id;
    public int intID = -1;
    Double2D desiredLocation = null;
    Double2D suggestedLocation = null;
    int steps = 0;
    public static final int AGENT = 0;
    public static final int TARGET = 1;
    protected int agentState;
    protected Color agentColor = new Color(0, 0, 0);
    protected Color targetColor = new Color(255, 0, 0);
    public Double2D agentLocation = null;

    public CTOAgent(Double2D location, int state, String id) {
        super(8.0);
        this.agentLocation = location;
        this.setState(state);
        this.id = id;
        if (id.startsWith("A")) {
            try {
                this.intID = Integer.parseInt(id.substring(5));
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Exception generated: " + e);
                System.exit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Exception generated: " + e);
                System.exit(1);
            }
        } else {
            try {
                this.intID = Integer.parseInt(id.substring(6));
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Exception generated: " + e);
                System.exit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Exception generated: " + e);
                System.exit(1);
            }
        }
    }

    public void step(SimState state) {
        CooperativeObservation hb = (CooperativeObservation)state;
        Double2D location = this.agentLocation;
        if (this.agentState == 0) {
            hb.agentPos[this.intID] = location;
        } else {
            hb.targetPos[this.intID] = location;
        }
        if (this.agentState == 0) {
            this.suggestedLocation = hb.kMeansEngine.getGoalPosition(this.intID);
            if (this.suggestedLocation != null) {
                this.desiredLocation = this.suggestedLocation;
            } else {
                --this.steps;
                if (this.steps <= 0) {
                    this.desiredLocation = new Double2D(state.random.nextDouble() * 392.0 + 0.0 + 4.0, state.random.nextDouble() * 392.0 + 0.0 + 4.0);
                    this.steps = 100;
                }
            }
        } else {
            --this.steps;
            if (this.desiredLocation == null || this.steps <= 0) {
                this.desiredLocation = new Double2D(state.random.nextDouble() * 392.0 + 0.0 + 4.0, state.random.nextDouble() * 392.0 + 0.0 + 4.0);
                this.steps = 100;
            }
        }
        double dx = this.desiredLocation.x - location.x;
        double dy = this.desiredLocation.y - location.y;
        if (dx > 0.5) {
            dx = 0.5;
        } else if (dx < -0.5) {
            dx = -0.5;
        }
        if (dy > 0.5) {
            dy = 0.5;
        } else if (dy < -0.5) {
            dy = -0.5;
        }
        if (dx < 0.5 && dx > -0.5 && dy < 0.5 && dy > -0.5) {
            this.steps = 0;
        }
        if (this.agentState == 0) {
            dx *= 2.0;
            dy *= 2.0;
        }
        if (!hb.acceptablePosition(this, new Double2D(location.x + dx, location.y + dy))) {
            this.steps = 0;
        } else {
            this.agentLocation = new Double2D(location.x + dx, location.y + dy);
            hb.environment.setObjectLocation((Object)this, this.agentLocation);
        }
    }

    public int getState() {
        return this.agentState;
    }

    void setState(int agentState) {
        if (agentState != 0 && agentState != 1) {
            throw new RuntimeException("Unknown state desired to be set (command ignored!): " + agentState);
        }
        this.agentState = agentState;
        this.paint = agentState == 0 ? this.agentColor : this.targetColor;
    }
}

