/*
 * Decompiled with CFR 0.152.
 */
package sim.app.cto;

import sim.app.cto.CTOAgent;
import sim.app.cto.KMeansEngine;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Bag;
import sim.util.Double2D;

public class CooperativeObservation
extends SimState {
    public static final double XMIN = 0.0;
    public static final double XMAX = 400.0;
    public static final double YMIN = 0.0;
    public static final double YMAX = 400.0;
    public static final double DIAMETER = 8.0;
    public static final int NUM_TARGETS = 40;
    public static final int NUM_AGENTS = 10;
    Double2D[] agentPos;
    Double2D[] targetPos;
    public Continuous2D environment = null;
    KMeansEngine kMeansEngine;

    public CooperativeObservation(long seed) {
        super(seed);
    }

    boolean conflict(Object agent1, Double2D a, Object agent2, Double2D b) {
        return (a.x > b.x && a.x < b.x + 8.0 || a.x + 8.0 > b.x && a.x + 8.0 < b.x + 8.0) && (a.y > b.y && a.y < b.y + 8.0 || a.y + 8.0 > b.y && a.y + 8.0 < b.y + 8.0);
    }

    boolean acceptablePosition(Object agent, Double2D location) {
        if (location.x < 4.0 || location.x > 396.0 || location.y < 4.0 || location.y > 396.0) {
            return false;
        }
        Bag misteriousObjects = this.environment.getObjectsWithinDistance(location, Math.max(16.0, 16.0));
        if (misteriousObjects != null) {
            for (int i = 0; i < misteriousObjects.numObjs; ++i) {
                CTOAgent ta;
                if (misteriousObjects.objs[i] == null || misteriousObjects.objs[i] == agent || !this.conflict(agent, location, ta = (CTOAgent)misteriousObjects.objs[i], this.environment.getObjectLocation(ta))) continue;
                return false;
            }
        }
        return true;
    }

    public void start() {
        int i;
        super.start();
        this.agentPos = new Double2D[10];
        for (i = 0; i < 10; ++i) {
            this.agentPos[i] = new Double2D();
        }
        this.targetPos = new Double2D[40];
        for (i = 0; i < 40; ++i) {
            this.targetPos[i] = new Double2D();
        }
        this.kMeansEngine = new KMeansEngine(this);
        this.environment = new Continuous2D(8.0, 400.0, 400.0);
        for (int x = 0; x < 50; ++x) {
            Double2D loc = null;
            CTOAgent agent = null;
            int times = 0;
            do {
                loc = new Double2D(this.random.nextDouble() * 392.0 + 0.0 + 4.0, this.random.nextDouble() * 392.0 + 0.0 + 4.0);
                agent = x < 10 ? new CTOAgent(loc, 0, "Agent" + x) : new CTOAgent(loc, 1, "Target" + (x - 10));
                if (++times != 1000) continue;
                System.err.println("Cannot place agents. Exiting....");
                System.exit(1);
            } while (!this.acceptablePosition(agent, loc));
            this.environment.setObjectLocation((Object)agent, loc);
            this.schedule.scheduleRepeating(agent);
        }
    }

    public static void main(String[] args) {
        CooperativeObservation.doLoop(CooperativeObservation.class, args);
        System.exit(0);
    }
}

