/*
 * Decompiled with CFR 0.152.
 */
package sim.app.flockers;

import sim.app.flockers.Flocker;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Flockers
extends SimState {
    public Continuous2D flockers;
    public double width = 150.0;
    public double height = 150.0;
    public int numFlockers = 200;
    public double cohesion = 1.0;
    public double avoidance = 1.0;
    public double randomness = 1.0;
    public double consistency = 1.0;
    public double momentum = 1.0;
    public double deadFlockerProbability = 0.1;
    public double neighborhood = 10.0;
    public double jump = 0.7;

    public double getCohesion() {
        return this.cohesion;
    }

    public void setCohesion(double val) {
        if (val >= 0.0) {
            this.cohesion = val;
        }
    }

    public double getAvoidance() {
        return this.avoidance;
    }

    public void setAvoidance(double val) {
        if (val >= 0.0) {
            this.avoidance = val;
        }
    }

    public double getRandomness() {
        return this.randomness;
    }

    public void setRandomness(double val) {
        if (val >= 0.0) {
            this.randomness = val;
        }
    }

    public double getConsistency() {
        return this.consistency;
    }

    public void setConsistency(double val) {
        if (val >= 0.0) {
            this.consistency = val;
        }
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setMomentum(double val) {
        if (val >= 0.0) {
            this.momentum = val;
        }
    }

    public int getNumFlockers() {
        return this.numFlockers;
    }

    public void setNumFlockers(int val) {
        if (val >= 1) {
            this.numFlockers = val;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double val) {
        if (val > 0.0) {
            this.width = val;
        }
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double val) {
        if (val > 0.0) {
            this.height = val;
        }
    }

    public double getNeighborhood() {
        return this.neighborhood;
    }

    public void setNeighborhood(double val) {
        if (val > 0.0) {
            this.neighborhood = val;
        }
    }

    public double getDeadFlockerProbability() {
        return this.deadFlockerProbability;
    }

    public void setDeadFlockerProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.deadFlockerProbability = val;
        }
    }

    public Double2D[] getLocations() {
        if (this.flockers == null) {
            return new Double2D[0];
        }
        Bag b = this.flockers.getAllObjects();
        if (b == null) {
            return new Double2D[0];
        }
        Double2D[] locs = new Double2D[b.numObjs];
        for (int i = 0; i < b.numObjs; ++i) {
            locs[i] = this.flockers.getObjectLocation(b.objs[i]);
        }
        return locs;
    }

    public Double2D[] getInvertedLocations() {
        if (this.flockers == null) {
            return new Double2D[0];
        }
        Bag b = this.flockers.getAllObjects();
        if (b == null) {
            return new Double2D[0];
        }
        Double2D[] locs = new Double2D[b.numObjs];
        for (int i = 0; i < b.numObjs; ++i) {
            locs[i] = this.flockers.getObjectLocation(b.objs[i]);
            locs[i] = new Double2D(locs[i].y, locs[i].x);
        }
        return locs;
    }

    public Flockers(long seed) {
        super(seed);
    }

    public void start() {
        super.start();
        this.flockers = new Continuous2D(this.neighborhood / 1.5, this.width, this.height);
        for (int x = 0; x < this.numFlockers; ++x) {
            Double2D location = new Double2D(this.random.nextDouble() * this.width, this.random.nextDouble() * this.height);
            Flocker flocker = new Flocker(location);
            if (this.random.nextBoolean(this.deadFlockerProbability)) {
                flocker.dead = true;
            }
            this.flockers.setObjectLocation((Object)flocker, location);
            flocker.flockers = this.flockers;
            flocker.theFlock = this;
            this.schedule.scheduleRepeating(flocker);
        }
    }

    public static void main(String[] args) {
        Flockers.doLoop(Flockers.class, args);
        System.exit(0);
    }
}

