/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs3d;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.heatbugs.HeatBugs;
import sim.display.Console;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.grid.SparseGrid2DPortrayal3D;
import sim.portrayal3d.grid.SparseGridPortrayal3D;
import sim.portrayal3d.grid.ValueGrid2DPortrayal3D;
import sim.portrayal3d.grid.quad.MeshPortrayal;
import sim.portrayal3d.grid.quad.QuadPortrayal;
import sim.portrayal3d.grid.quad.TilePortrayal;
import sim.portrayal3d.simple.ConePortrayal3D;
import sim.portrayal3d.simple.TransformedPortrayal3D;
import sim.util.gui.SimpleColorMap;

public class HeatBugs3DWithUI
extends GUIState {
    public JFrame displayFrame;
    public static final int CLASSIC = 0;
    public static final int STACKED = 1;
    public static final int TILE = 0;
    public static final int MESH = 1;
    public static final int NOZ = 2;
    int bugmode = 1;
    int heatmode = 1;
    ValueGrid2DPortrayal3D heatPortrayal = new ValueGrid2DPortrayal3D();
    FieldPortrayal3D bugPortrayal = null;
    QuadPortrayal quadP = null;
    public Display3D display;

    public static void main(String[] args) {
        HeatBugs3DWithUI heatbugs = new HeatBugs3DWithUI(new HeatBugs(System.currentTimeMillis(), 100, 100, 100), 1, 1);
        Console c = new Console(heatbugs);
        c.setVisible(true);
    }

    public HeatBugs3DWithUI() {
        this(new HeatBugs(System.currentTimeMillis()), 1, 1);
    }

    public HeatBugs3DWithUI(SimState state, int bugmode, int heatmode) {
        super(state);
        this.bugmode = bugmode;
        this.heatmode = heatmode;
        this.bugPortrayal = bugmode == 1 ? new SparseGrid2DPortrayal3D() : new SparseGridPortrayal3D();
    }

    public static String getName() {
        return "3D HeatBugs";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        SimpleColorMap cm = new SimpleColorMap();
        cm.setLevels(0.0, 32000.0, Color.blue, Color.red);
        TransformedPortrayal3D p = new TransformedPortrayal3D(new ConePortrayal3D());
        p.rotateX(90.0);
        this.bugPortrayal.setPortrayalForAll(p);
        switch (this.heatmode) {
            case 0: {
                this.quadP = new TilePortrayal(cm, 5.0E-4f);
                break;
            }
            case 1: {
                this.quadP = new MeshPortrayal(cm, 5.0E-4f);
                break;
            }
            case 2: {
                this.quadP = new TilePortrayal(cm);
                this.bugPortrayal.translate(0.0, 0.0, 1.0);
            }
        }
        this.heatPortrayal.setPortrayalForAll(this.quadP);
        this.heatPortrayal.setField(((HeatBugs)this.state).valgrid);
        this.bugPortrayal.setField(((HeatBugs)this.state).buggrid);
        this.display.reset();
        this.display.createSceneGraph();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.heatPortrayal, "Heat");
        this.display.attach(this.bugPortrayal, "Bugs");
        this.heatPortrayal.setValueName("Heat");
        HeatBugs hbState = (HeatBugs)this.state;
        this.display.translate((double)(hbState.gridWidth - 1) / -2.0, (double)(hbState.gridHeight - 1) / -2.0, 0.0);
        this.display.scale(1.0 / (double)Math.max(hbState.gridWidth, hbState.gridHeight));
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

