/*
 * Decompiled with CFR 0.152.
 */
package sim.app.keepaway;

import java.awt.Color;
import sim.app.keepaway.Entity;
import sim.app.keepaway.Keepaway;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Ball
extends Entity
implements Steppable {
    public MutableDouble2D stillPos;
    public double dt;
    MutableDouble2D friction = new MutableDouble2D();
    MutableDouble2D stuckPos = new MutableDouble2D();

    public Ball(double x, double y) {
        super(x, y, 1.0, Color.white);
        this.cap = 2.0;
        this.bump = new MutableDouble2D(0.0, 0.0);
        this.stillPos = new MutableDouble2D(0.0, 0.0);
        this.dt = 0.0;
    }

    public MutableDouble2D getForces(Keepaway keepaway) {
        this.sumVector.setTo(0.0, 0.0);
        Bag objs = keepaway.fieldEnvironment.getObjectsWithinDistance(new Double2D(this.loc.x, this.loc.y), 100.0);
        double dist = 0.0;
        for (int x = 0; x < objs.numObjs; ++x) {
            if (objs.objs[x] != this && ((Entity)objs.objs[x]).radius + this.radius > (dist = ((Entity)objs.objs[x]).loc.distance(this.loc)) && !(objs.objs[x] instanceof Ball)) continue;
        }
        this.sumVector = this.sumVector.addIn(this.bump);
        this.bump.x = 0.0;
        this.bump.y = 0.0;
        return this.sumVector;
    }

    public void step(SimState state) {
        Keepaway keepaway = (Keepaway)state;
        MutableDouble2D force = this.getForces(keepaway);
        this.accel.multiply(force, 1.0 / this.mass);
        this.friction.multiply(this.velocity, -0.025);
        this.velocity.addIn(this.accel);
        this.velocity.addIn(this.friction);
        this.capVelocity();
        this.newLoc.add(this.loc, this.velocity);
        if (this.isValidMove(keepaway, this.newLoc)) {
            this.loc = this.newLoc;
        }
        if (this.loc.distanceSq(this.stuckPos) < 0.010000000000000002) {
            this.dt += 1.0;
        } else {
            this.dt = 0.0;
            this.stuckPos.setTo(this.loc);
        }
        if (this.dt > 1000.0) {
            System.out.println("stuck");
            this.dt = 0.0;
            this.stuckPos.setTo(this.loc);
            this.loc.x = keepaway.random.nextDouble() * keepaway.xMax;
            this.loc.y = keepaway.random.nextDouble() * keepaway.yMax;
        }
        keepaway.fieldEnvironment.setObjectLocation((Object)this, new Double2D(this.loc));
    }
}

