/*
 * Decompiled with CFR 0.152.
 */
package sim.app.keepaway;

import java.awt.Color;
import java.awt.Paint;
import sim.app.keepaway.Keepaway;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public abstract class Entity
extends OvalPortrayal2D {
    public MutableDouble2D loc;
    public MutableDouble2D velocity;
    public MutableDouble2D bump;
    public MutableDouble2D force = new MutableDouble2D();
    public MutableDouble2D accel = new MutableDouble2D();
    public MutableDouble2D newLoc = new MutableDouble2D();
    public MutableDouble2D sumVector = new MutableDouble2D(0.0, 0.0);
    public double speed;
    public double radius;
    public double cap;
    public double mass;

    public double getX() {
        return this.loc.x;
    }

    public void setX(double newX) {
        this.loc.x = newX;
    }

    public double getY() {
        return this.loc.y;
    }

    public void setY(double newY) {
        this.loc.y = newY;
    }

    public double getVelocityX() {
        return this.velocity.x;
    }

    public void setVelocityX(double newX) {
        this.velocity.x = newX;
    }

    public double getVelocityY() {
        return this.velocity.y;
    }

    public void setVelocityY(double newY) {
        this.velocity.y = newY;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double newSpeed) {
        this.speed = newSpeed;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double newRadius) {
        this.radius = newRadius;
        this.scale = 2.0 * this.radius;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double newMass) {
        this.mass = newMass;
    }

    public Entity(double newX, double newY, double newRadius, Color c) {
        super((Paint)c, newRadius * 2.0);
        this.loc = new MutableDouble2D(newX, newY);
        this.velocity = new MutableDouble2D(0.0, 0.0);
        this.bump = new MutableDouble2D(0.0, 0.0);
        this.radius = newRadius;
        this.mass = 1.0;
        this.cap = 1.0;
        this.speed = 0.4;
    }

    public boolean isValidMove(Keepaway keepaway, MutableDouble2D newLoc) {
        Bag objs = keepaway.fieldEnvironment.getObjectsWithinDistance(new Double2D(this.loc.x, this.loc.y), 10.0);
        double dist = 0.0;
        for (int x = 0; x < objs.numObjs; ++x) {
            if (objs.objs[x] == this || !(((Entity)objs.objs[x]).radius + this.radius > (dist = ((Entity)objs.objs[x]).loc.distance(newLoc)))) continue;
            return false;
        }
        if (newLoc.x > keepaway.xMax) {
            if (this.velocity.x > 0.0) {
                this.velocity.x = -this.velocity.x;
            }
            return false;
        }
        if (newLoc.x < keepaway.xMin) {
            if (this.velocity.x < 0.0) {
                this.velocity.x = -this.velocity.x;
            }
            return false;
        }
        if (newLoc.y > keepaway.yMax) {
            if (this.velocity.y > 0.0) {
                this.velocity.y = -this.velocity.y;
            }
            return false;
        }
        if (newLoc.y < keepaway.yMin) {
            if (this.velocity.y < 0.0) {
                this.velocity.y = -this.velocity.y;
            }
            return false;
        }
        return true;
    }

    public void capVelocity() {
        if (this.velocity.length() > this.cap) {
            this.velocity = this.velocity.resize(this.cap);
        }
    }
}

