/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mav;

import sim.app.mav.MavDemo;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.Oriented2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Mav
implements Steppable,
Oriented2D {
    public static final double[] theta = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138};
    public static final double[] xd = new double[]{Math.cos(theta[0]), Math.cos(theta[1]), Math.cos(theta[2]), Math.cos(theta[3]), Math.cos(theta[4]), Math.cos(theta[5]), Math.cos(theta[6]), Math.cos(theta[7])};
    public static final double[] yd = new double[]{Math.sin(theta[0]), Math.sin(theta[1]), Math.sin(theta[2]), Math.sin(theta[3]), Math.sin(theta[4]), Math.sin(theta[5]), Math.sin(theta[6]), Math.sin(theta[7])};
    public int orientation = 0;
    public double x;
    public double y;
    double[] proximitySensors = new double[8];
    final double sinTheta = Math.sin(0.39269908169872414);
    final double cosTheta = Math.cos(0.39269908169872414);

    public double orientation2D() {
        return theta[this.orientation];
    }

    public Mav(int orientation, double x, double y) {
        this.orientation = orientation;
        this.x = x;
        this.y = y;
    }

    public void step(SimState state) {
        MavDemo mavdemo = (MavDemo)state;
        this.orientation += mavdemo.random.nextInt(3) - 1;
        if (this.orientation > 7) {
            this.orientation = 0;
        }
        if (this.orientation < 0) {
            this.orientation = 7;
        }
        this.x += xd[this.orientation];
        this.y += yd[this.orientation];
        if (this.x >= mavdemo.width) {
            this.x = mavdemo.width - 1.0;
        } else if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y >= mavdemo.height) {
            this.y = mavdemo.height - 1.0;
        } else if (this.y < 0.0) {
            this.y = 0.0;
        }
        mavdemo.mavs.setObjectLocation((Object)this, new Double2D(this.x, this.y));
        this.act(this.nearbyMAVs(mavdemo), this.currentSurface(mavdemo));
    }

    public void act(double[] sensorReading, int currentSurface) {
        if (currentSurface == 100) {
            System.out.println("Acting");
        }
    }

    public double[] nearbyMAVs(MavDemo mavdemo) {
        for (int i = 0; i < 8; ++i) {
            this.proximitySensors[i] = Double.MAX_VALUE;
        }
        double d = mavdemo.sensorRangeDistance * mavdemo.sensorRangeDistance;
        Bag nearbyMavs = mavdemo.mavs.getObjectsWithinDistance(new Double2D(this.x, this.y), 16.0, false, false);
        for (int i = 0; i < nearbyMavs.numObjs; ++i) {
            Mav mav = (Mav)nearbyMavs.objs[i];
            double mavDistance = (mav.x - this.x) * (mav.x - this.x) + (mav.y - this.y) * (mav.y - this.y);
            if (!(mavDistance < d)) continue;
            int octant = this.sensorForPoint(mav.x, mav.y);
            this.proximitySensors[octant] = Math.min(this.proximitySensors[octant], mavDistance);
        }
        return this.proximitySensors;
    }

    public int currentSurface(MavDemo mavdemo) {
        for (int i = 0; i < mavdemo.region.length; ++i) {
            if (!mavdemo.region[i].area.contains(this.x - mavdemo.region[i].originx, this.y - mavdemo.region[i].originy)) continue;
            return mavdemo.region[i].surface;
        }
        return 0;
    }

    public int sensorForPoint(double px, double py) {
        int o = 0;
        double xx = (px -= this.x) * this.cosTheta + (py -= this.y) * -this.sinTheta;
        double yy = px * this.sinTheta + py * this.cosTheta;
        if (xx != 0.0 || yy != 0.0) {
            o = xx > 0.0 ? (yy > 0.0 ? (xx > yy ? 0 : 1) : (xx > -yy ? 7 : 6)) : (yy > 0.0 ? (-xx > yy ? 3 : 2) : (-xx > -yy ? 4 : 5));
        }
        if ((o += this.orientation) >= 8) {
            o %= 8;
        }
        return o;
    }
}

