/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mav;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.mav.MavDemo;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.CircledPortrayal2D;
import sim.portrayal.simple.LabelledPortrayal2D;
import sim.portrayal.simple.OrientedPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;

public class MavDemoWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D obstaclePortrayal = new ContinuousPortrayal2D();
    ContinuousPortrayal2D mavPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new MavDemoWithUI().createController();
    }

    public MavDemoWithUI() {
        super(new MavDemo(System.currentTimeMillis()));
    }

    public MavDemoWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Micro Air Vehicles";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        MavDemo mavdemo = (MavDemo)this.state;
        this.obstaclePortrayal.setField(mavdemo.ground);
        this.mavPortrayal.setField(mavdemo.mavs);
        this.mavPortrayal.setPortrayalForAll(new CircledPortrayal2D(new LabelledPortrayal2D(new OrientedPortrayal2D(new OvalPortrayal2D(20.0), 0, 20.0), 20.0, null, Color.blue, true), 0.0, 30.0, Color.blue, true));
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(500.0, 500.0, this);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Mav Demonstration Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.obstaclePortrayal, "Regions");
        this.display.attach(this.mavPortrayal, "MAVs");
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

