/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mousetraps;

import sim.app.mousetraps.MouseTrap;
import sim.app.mousetraps.MouseTraps;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Double3D;

public class Ball
implements Steppable {
    public double posX;
    public double posY;
    public double posZ;
    public double velocityX;
    public double velocityY;
    public double velocityZ;

    public Ball(double x, double y, double z, double vx, double vy, double vz) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.velocityX = vx;
        this.velocityY = vy;
        this.velocityZ = vz;
    }

    public void step(SimState state) {
        MouseTraps sim = (MouseTraps)state;
        if (this.posZ <= 0.0 && this.velocityZ <= 0.0) {
            sim.schedule.scheduleOnce(sim.schedule.getTime() + 1.0, (Steppable)new MouseTrap(sim.discretizeX(this.posX), sim.discretizeY(this.posY)));
            sim.ballSpace.remove(this);
            return;
        }
        double timeStepDuration = 0.015625;
        this.posX += this.velocityX * timeStepDuration;
        this.posY += this.velocityY * timeStepDuration;
        this.posZ += this.velocityZ * timeStepDuration;
        this.velocityZ -= 9.8 * timeStepDuration;
        if (sim.toroidalWorld) {
            this.posX = (this.posX + sim.spaceWidth) % sim.spaceWidth;
            this.posY = (this.posY + sim.spaceHeight) % sim.spaceHeight;
        } else {
            if (this.posX > sim.spaceWidth) {
                this.posX = sim.spaceWidth;
                this.velocityX = -this.velocityX;
            }
            if (this.posX < 0.0) {
                this.posX = 0.0;
                this.velocityX = -this.velocityX;
            }
            if (this.posY >= sim.spaceHeight) {
                this.posY = sim.spaceHeight;
                this.velocityY = -this.velocityY;
            }
            if (this.posY < 0.0) {
                this.posY = 0.0;
                this.velocityY = -this.velocityY;
            }
        }
        sim.ballSpace.setObjectLocation((Object)this, new Double3D(this.posX, this.posY, this.posZ));
        sim.schedule.scheduleOnce(this);
    }
}

