/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mousetraps;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.mousetraps.MouseTraps;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class MouseTrapsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D trapPortrayal = new FastValueGridPortrayal2D("Traps");

    public static void main(String[] args) {
        new MouseTrapsWithUI().createController();
    }

    public MouseTrapsWithUI() {
        super(new MouseTraps(System.currentTimeMillis()));
    }

    public MouseTrapsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Mouse Traps";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.trapPortrayal.setField(((MouseTraps)this.state).trapStateGrid);
        ((SimpleColorMap)this.trapPortrayal.getMap()).setLevels(0.0, 1.0, Color.black, Color.red);
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.trapPortrayal, "Traps");
        this.display.setBackdrop(Color.black);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

