/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mousetraps3d;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.mousetraps.MouseTraps;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.grid.ValueGrid2DPortrayal3D;
import sim.portrayal3d.grid.quad.TilePortrayal;
import sim.portrayal3d.simple.SpherePortrayal3D;
import sim.portrayal3d.simple.WireFrameBoxPortrayal3D;
import sim.util.gui.SimpleColorMap;

public class MouseTraps3DWithUI
extends GUIState {
    public JFrame displayFrame;
    ValueGrid2DPortrayal3D trapsPortrayal = new ValueGrid2DPortrayal3D();
    ContinuousPortrayal3D ballPortrayal = new ContinuousPortrayal3D();
    WireFrameBoxPortrayal3D wireFrameP;
    double scale;
    public Display3D display;

    public static void main(String[] args) {
        new MouseTraps3DWithUI().createController();
    }

    public MouseTraps3DWithUI() {
        super(new MouseTraps(System.currentTimeMillis(), 40.0, 15, 10, 120.0, 80.0, false));
    }

    public static String getName() {
        return "3D Mouse Traps";
    }

    public void start() {
        super.start();
        this.setup3DPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setup3DPortrayals();
    }

    public void setup3DPortrayals() {
        this.trapsPortrayal.setField(((MouseTraps)this.state).trapStateGrid);
        this.ballPortrayal.setField(((MouseTraps)this.state).ballSpace);
        this.ballPortrayal.setPortrayalForAll(new SpherePortrayal3D(Color.green));
        this.display.createSceneGraph();
        this.display.reset();
    }

    public void init(Controller c) {
        super.init(c);
        MouseTraps sim = (MouseTraps)this.state;
        this.trapsPortrayal.setField(sim.trapStateGrid);
        SimpleColorMap map = new SimpleColorMap();
        map.setLevels(0.0, 1.0, Color.blue, Color.gray);
        this.trapsPortrayal.setPortrayalForAll(new TilePortrayal(map));
        this.trapsPortrayal.translate(0.5, 0.5, 0.0);
        this.trapsPortrayal.scale(sim.spaceWidth / (double)sim.trapGridWidth);
        this.ballPortrayal.setField(sim.ballSpace);
        this.wireFrameP = new WireFrameBoxPortrayal3D(0.0, 0.0, 0.0, sim.spaceWidth, sim.spaceHeight, sim.spaceLength);
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.trapsPortrayal, "Traps");
        this.display.attach(this.ballPortrayal, "Balls");
        this.display.attach(this.wireFrameP, "Fish tank");
        this.display.translate(-sim.spaceWidth / 2.0, -sim.spaceHeight / 2.0, -sim.spaceLength / 2.0);
        this.display.scale(1.0 / Math.max(sim.spaceHeight, Math.max(sim.spaceWidth, sim.spaceLength)));
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

