/*
 * Decompiled with CFR 0.152.
 */
package sim.app.networktest;

import sim.app.networktest.CustomNode;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.field.network.Network;
import sim.util.Double2D;

public class NetworkTest
extends SimState {
    public static final double XMIN = 0.0;
    public static final double XMAX = 800.0;
    public static final double YMIN = 0.0;
    public static final double YMAX = 600.0;
    public static final double DIAMETER = 8.0;
    public Continuous2D environment = null;
    public Network network = null;

    public NetworkTest(long seed) {
        super(seed);
    }

    boolean acceptablePosition(CustomNode node, Double2D location) {
        return !(location.x < 4.0 || location.x > 796.0 || location.y < 4.0) && !(location.y > 596.0);
    }

    CustomNode makeNode(String name) {
        CustomNode node = new CustomNode(name);
        this.environment.setObjectLocation((Object)node, new Double2D(this.random.nextDouble() * 792.0 + 0.0 + 4.0, this.random.nextDouble() * 592.0 + 0.0 + 4.0));
        this.network.addNode(node);
        this.schedule.scheduleRepeating(node);
        return node;
    }

    public void start() {
        super.start();
        this.environment = new Continuous2D(16.0, 800.0, 600.0);
        this.network = new Network();
        CustomNode[] nodes = new CustomNode[]{this.makeNode("node0"), this.makeNode("node1"), this.makeNode("node2"), this.makeNode("node3"), this.makeNode("node4"), this.makeNode("node5")};
        this.network.addEdge(nodes[0], nodes[1], "0-1");
        this.network.addEdge(nodes[1], nodes[2], "1-2");
        this.network.addEdge(nodes[2], nodes[3], "2-3");
        this.network.addEdge(nodes[3], nodes[4], "3-4");
        this.network.addEdge(nodes[4], nodes[0], "4-0");
        this.network.addEdge(nodes[0], nodes[5], "0-5");
        this.network.addEdge(nodes[1], nodes[5], "1-5");
        this.network.addEdge(nodes[2], nodes[5], "2-5");
        this.network.addEdge(nodes[3], nodes[5], "3-5");
        this.network.addEdge(nodes[4], nodes[5], "4-5");
    }

    public static void main(String[] args) {
        NetworkTest.doLoop(NetworkTest.class, args);
        System.exit(0);
    }
}

