/*
 * Decompiled with CFR 0.152.
 */
package sim.app.networktest;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.networktest.NetworkTest;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.portrayal.simple.CircledPortrayal2D;
import sim.portrayal.simple.MovablePortrayal2D;

public class NetworkTestWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    NetworkPortrayal2D edgePortrayal = new NetworkPortrayal2D();
    ContinuousPortrayal2D nodePortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new NetworkTestWithUI().createController();
    }

    public NetworkTestWithUI() {
        super(new NetworkTest(System.currentTimeMillis()));
    }

    public NetworkTestWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Network Test";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.edgePortrayal.setField(new SpatialNetwork2D(((NetworkTest)this.state).environment, ((NetworkTest)this.state).network));
        SimpleEdgePortrayal2D p = new SimpleEdgePortrayal2D(Color.lightGray, Color.lightGray, Color.black);
        p.setShape(1);
        p.setBaseWidth(10.0);
        this.edgePortrayal.setPortrayalForAll(p);
        this.nodePortrayal.setField(((NetworkTest)this.state).environment);
        this.nodePortrayal.setPortrayalForAll(new MovablePortrayal2D(new CircledPortrayal2D(null, 20.0, 10.0, Color.green, true)));
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(800.0, 600.0, this);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Network Test Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.edgePortrayal, "Edges");
        this.display.attach(this.nodePortrayal, "Nodes");
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

