/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import sim.app.pacman.Agent;
import sim.app.pacman.PacMan;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;
import sim.util.Valuable;

public abstract class Ghost
extends Agent
implements Steppable,
Valuable {
    public static final int FRIGHTENED_PERIOD = 360;
    public static final int FRIGHTENED_DISCRETIZATION = 15;
    public static final int REGULAR_DISCRETIZATION = 10;
    public static final int WAITING_PERIOD = 360;
    public static final int INITIAL_WAITING_PERIOD = 90;
    public Double2D exitLocation = new Double2D(13.5, 16.0);
    public int frightened = 0;
    public int waiting = 90;
    public boolean exiting = false;
    static final int MIN_DIST_FOR_TOROIDAL = 4;

    public double doubleValue() {
        if (this.frightened > 0) {
            if (this.frightened > 120) {
                return 4.0;
            }
            int s = this.frightened / 20;
            if (s % 2 == 0) {
                return 4.0;
            }
            return 5.0;
        }
        switch (this.lastAction) {
            case 0: {
                return 0.0;
            }
            case 3: {
                return 1.0;
            }
            case 2: {
                return 2.0;
            }
            case 1: {
                return 3.0;
            }
        }
        return 3.0;
    }

    public void putInJail() {
        this.location = new MutableDouble2D(this.exitLocation);
        this.pacman.agents.setObjectLocation((Object)this, this.exitLocation);
        this.lastAction = 3;
        this.frightened = 0;
        this.waiting = 360;
    }

    public Ghost(PacMan pacman) {
        super(pacman);
        this.lastAction = 3;
        pacman.schedule.scheduleRepeating(this, 1, 1.0);
    }

    public static int reverseOf(int action) {
        switch (action) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public abstract Double2D getTarget();

    public void step(SimState state) {
        if (this.pacman.frightenGhosts && this.waiting <= 0 && !this.exiting) {
            this.lastAction = Ghost.reverseOf(this.lastAction);
            this.frightened = 360;
        }
        this.discretization = this.frightened > 0 ? 15 : 10;
        if (this.waiting <= 0 && this.location.x == this.exitLocation.x && this.location.y <= this.exitLocation.y && this.location.y > this.exitLocation.y - 3.0) {
            this.exiting = true;
            double x = this.location.x;
            double y = this.location.y;
            if ((y = this.pacman.agents.sty(y - this.speed())) <= this.exitLocation.y - 3.0) {
                y = this.exitLocation.y - 3.0;
            }
            this.changeLocation(x, y);
            this.lastAction = this.pacman.random.nextBoolean() ? 3 : 1;
        } else {
            this.exiting = false;
            if (this.location.x == (double)((int)this.location.x) && this.location.y == (double)((int)this.location.y)) {
                double x = this.location.x;
                double y = this.location.y;
                int bestAction = -1;
                double bestActionDistanceSquared = Double.POSITIVE_INFINITY;
                Double2D target = this.getTarget();
                int reverseAction = Ghost.reverseOf(this.lastAction);
                Continuous2D agents = this.pacman.agents;
                double nx = 0.0;
                double ny = 0.0;
                int tick = 1;
                for (int action = 0; action <= 3; ++action) {
                    if (action == reverseAction || !this.isPossibleToDoAction(action)) continue;
                    switch (action) {
                        case 0: {
                            nx = x;
                            ny = y - 1.0;
                            break;
                        }
                        case 1: {
                            nx = x + 1.0;
                            ny = y;
                            break;
                        }
                        case 2: {
                            nx = x;
                            ny = y + 1.0;
                            break;
                        }
                        case 3: {
                            nx = x - 1.0;
                            ny = y;
                        }
                    }
                    double dist = 0.0;
                    dist = this.frightened <= 0 && Math.abs(agents.stx(target.x - nx)) <= 4.0 || Math.abs(agents.sty(target.y - ny)) < -4.0 ? agents.tds(target, new Double2D(nx, ny)) : target.distanceSq(new Double2D(nx, ny));
                    if ((this.frightened > 0 || bestAction != -1 && !(dist < bestActionDistanceSquared)) && (this.frightened <= 0 || !this.pacman.random.nextBoolean(1.0 / (double)tick++))) continue;
                    bestAction = action;
                    bestActionDistanceSquared = dist;
                }
                if (bestAction == -1) {
                    bestAction = reverseAction;
                }
                this.performAction(bestAction);
            } else {
                this.performAction(this.lastAction);
            }
            if (--this.frightened < 0) {
                this.frightened = 0;
            }
            if (--this.waiting < 0) {
                this.waiting = 0;
            }
        }
    }
}

