/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import sim.field.grid.IntGrid2D;

public class IntPBMGrid2D
extends IntGrid2D {
    public IntPBMGrid2D(InputStream in) {
        this(new InputStreamReader(in));
    }

    public IntPBMGrid2D(Reader reader) {
        super(0, 0);
        this.read(new BufferedReader(reader));
    }

    public IntPBMGrid2D(String filename) {
        super(0, 0);
        this.read(filename);
    }

    public IntPBMGrid2D(File file) {
        super(0, 0);
        this.read(file);
    }

    public void read(String filename) {
        try {
            this.read(new BufferedReader(new FileReader(filename)));
        }
        catch (IOException e) {
            throw new RuntimeException("Whoops!");
        }
    }

    public void read(File file) {
        try {
            this.read(new BufferedReader(new FileReader(file)));
        }
        catch (IOException e) {
            throw new RuntimeException("Whoops!");
        }
    }

    public void read(InputStream in) {
        this.read(new BufferedReader(new InputStreamReader(in)));
    }

    public void read(BufferedReader in) {
        try {
            int w = 0;
            int h = 0;
            int tmp = 0;
            String line = in.readLine().trim();
            if (!line.equals("P1")) {
                throw new IOException("The image's magic number is not P1.");
            }
            in.readLine();
            line = in.readLine().trim();
            String[] t = line.split("\\s+", 2);
            w = Integer.valueOf(t[0]);
            h = Integer.valueOf(t[1]);
            if (w <= 1 || h <= 1) {
                throw new IOException("The w and h of the image are invalid.");
            }
            this.width = w;
            this.height = h;
            this.field = new int[w][h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    while ((tmp = in.read()) != -1 && tmp != 48 && tmp != 49) {
                    }
                    this.field[x][y] = tmp == -1 ? 0 : (tmp == 48 ? 0 : 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.height = 100;
            this.width = 100;
            this.field = new int[100][100];
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < 100; ++j) {
                    this.field[i][j] = 0;
                }
            }
        }
    }
}

