/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.MutableDouble;
import sim.util.MutableInt2D;

public class MazeCellPortrayal
extends SimplePortrayal2D {
    IntGrid2D field;
    QuadCurve2D.Double curve = new QuadCurve2D.Double();
    Line2D.Double line = new Line2D.Double();
    Color color = new Color(33, 33, 222);
    BasicStroke stroke = new BasicStroke(2.0f);

    public MazeCellPortrayal(IntGrid2D field) {
        this.field = field;
    }

    public void draw(Object object, Graphics2D g, DrawInfo2D info) {
        int[][] grid = this.field.field;
        MutableInt2D location = (MutableInt2D)info.location;
        int x = location.x;
        int y = location.y;
        double ox = info.draw.x;
        double oy = info.draw.y;
        double sc = info.draw.width / 2.0;
        if ((int)((MutableDouble)object).val == 0) {
            return;
        }
        int height = this.field.getHeight() - 1;
        int width = this.field.getWidth() - 1;
        int n = y == 0 ? 1 : grid[x][y - 1];
        int w = x == 0 ? 1 : grid[x - 1][y];
        int s = y == height ? 1 : grid[x][y + 1];
        int e = x == width ? 1 : grid[x + 1][y];
        g.setColor(this.color);
        g.setStroke(this.stroke);
        if (n == 0) {
            if (w == 0) {
                this.curve.setCurve(ox + sc, oy, ox, oy, ox, oy + sc);
                g.draw(this.curve);
            } else if (e == 0) {
                this.curve.setCurve(ox - sc, oy, ox, oy, ox, oy + sc);
                g.draw(this.curve);
            } else {
                this.line.setLine(ox + sc, oy, ox - sc, oy);
                g.draw(this.line);
            }
        } else if (s == 0) {
            if (w == 0) {
                this.curve.setCurve(ox + sc, oy, ox, oy, ox, oy - sc);
                g.draw(this.curve);
            } else if (e == 0) {
                this.curve.setCurve(ox - sc, oy, ox, oy, ox, oy - sc);
                g.draw(this.curve);
            } else {
                this.line.setLine(ox + sc, oy, ox - sc, oy);
                g.draw(this.line);
            }
        } else if (e == 0) {
            this.line.setLine(ox, oy + sc, ox, oy - sc);
            g.draw(this.line);
        } else if (w == 0) {
            this.line.setLine(ox, oy + sc, ox, oy - sc);
            g.draw(this.line);
        } else {
            int se;
            int nw = y == 0 || x == 0 ? 1 : grid[x - 1][y - 1];
            int sw = y == height || x == 0 ? 1 : grid[x - 1][y + 1];
            int ne = y == 0 || x == width ? 1 : grid[x + 1][y - 1];
            int n2 = se = y == height || x == width ? 1 : grid[x + 1][y + 1];
            if (nw == 0) {
                this.curve.setCurve(ox - sc, oy, ox, oy, ox, oy - sc);
                g.draw(this.curve);
            } else if (sw == 0) {
                this.curve.setCurve(ox - sc, oy, ox, oy, ox, oy + sc);
                g.draw(this.curve);
            } else if (ne == 0) {
                this.curve.setCurve(ox + sc, oy, ox, oy, ox, oy - sc);
                g.draw(this.curve);
            } else if (se == 0) {
                this.curve.setCurve(ox + sc, oy, ox, oy, ox, oy + sc);
                g.draw(this.curve);
            }
        }
    }
}

