/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import sim.app.pacman.Agent;
import sim.app.pacman.Dot;
import sim.app.pacman.Energizer;
import sim.app.pacman.Ghost;
import sim.app.pacman.PacMan;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Bag;
import sim.util.Double2D;

public class Pac
extends Agent
implements Steppable {
    public static final int WAIT_TIME = 100;
    public static final int SPIN_TIME = 100;
    public static final int SPIN_SPEED = 5;
    public static final int PAC_DISCRETIZATION = 9;
    public int eatGhostScore = 200;
    public int tag;
    public Stoppable stopper;

    public Pac(PacMan pacman, int tag) {
        super(pacman);
        this.tag = tag;
        this.discretization = 9;
        this.stopper = pacman.schedule.scheduleRepeating(this, 0, 1.0);
    }

    public Double2D getStartLocation() {
        return new Double2D(13.5, 25.0);
    }

    protected void doPolicyStep(SimState state) {
        int nextAction = this.pacman.getNextAction(this.tag);
        if (this.isPossibleToDoAction(nextAction)) {
            this.performAction(nextAction);
        } else if (this.isPossibleToDoAction(this.lastAction)) {
            this.performAction(this.lastAction);
        }
    }

    public void step(SimState state) {
        Object obj;
        int i;
        this.doPolicyStep(state);
        Bag nearby = this.pacman.dots.getObjectsWithinDistance(new Double2D(this.location), 0.3);
        for (i = 0; i < nearby.numObjs; ++i) {
            obj = nearby.objs[i];
            if (obj instanceof Energizer && this.pacman.dots.getObjectLocation(obj).equals(this.location)) {
                this.pacman.score += 40;
                this.pacman.dots.remove(obj);
                this.eatGhostScore = 200;
                this.pacman.frightenGhosts = true;
                this.pacman.schedule.scheduleOnce(new Steppable(){

                    public void step(SimState state) {
                        Pac.this.pacman.frightenGhosts = false;
                    }
                }, -1);
            }
            if (!(obj instanceof Dot) || !this.pacman.dots.getObjectLocation(obj).equals(this.location)) continue;
            this.pacman.score += 10;
            this.pacman.dots.remove(obj);
        }
        if (nearby.numObjs > 0 && this.pacman.dots.size() == 0) {
            this.pacman.schedule.scheduleOnceIn(0.25, new Steppable(){

                public void step(SimState state) {
                    Pac.this.resetLevel();
                }
            });
        }
        nearby = this.pacman.agents.getObjectsWithinDistance(new Double2D(this.location), 0.3);
        for (i = 0; i < nearby.numObjs; ++i) {
            obj = nearby.objs[i];
            if (!(obj instanceof Ghost) || !(this.location.distanceSq(this.pacman.agents.getObjectLocation(obj)) <= 0.2)) continue;
            Ghost m = (Ghost)obj;
            if (m.frightened > 0) {
                this.pacman.score += this.eatGhostScore;
                this.eatGhostScore *= 2;
                m.putInJail();
                continue;
            }
            this.pacman.schedule.scheduleOnceIn(0.5, new Steppable(){

                public void step(SimState state) {
                    Pac.this.die();
                }
            });
        }
    }

    public void resetLevel() {
        this.pacman.schedule.clear();
        this.pacman.schedule.scheduleOnce(new Steppable(){
            public int count = 0;

            public void step(SimState state) {
                if (++this.count < 200) {
                    Pac.this.pacman.schedule.scheduleOnce(this);
                }
            }
        });
        this.pacman.schedule.scheduleOnceIn(200.0, new Steppable(){

            public void step(SimState state) {
                ++Pac.this.pacman.level;
                Pac.this.pacman.resetGame();
            }
        });
    }

    public void die() {
        ++this.pacman.deaths;
        if (this.pacman.pacsLeft() > 1) {
            if (this.stopper != null) {
                this.stopper.stop();
            }
            this.stopper = null;
            this.pacman.agents.remove(this);
            this.pacman.pacs[this.tag] = null;
            return;
        }
        this.pacman.schedule.clear();
        this.pacman.schedule.scheduleOnce(new Steppable(){
            public int count = 0;

            public void step(SimState state) {
                if (++this.count < 100) {
                    Pac.this.pacman.schedule.scheduleOnce(this);
                }
            }
        });
        this.pacman.schedule.scheduleOnceIn(100.0, new Steppable(){

            public void step(SimState state) {
                Bag b = Pac.this.pacman.agents.getAllObjects();
                for (int i = 0; i < b.numObjs; ++i) {
                    if (b.objs[i] == Pac.this) continue;
                    b.remove(i);
                    --i;
                }
            }
        });
        this.pacman.schedule.scheduleOnceIn(101.0, new Steppable(){
            public int count = 0;

            public void step(SimState state) {
                if (this.count % 5 == 0) {
                    Pac.this.lastAction = (Pac.this.lastAction + 1) % 4;
                }
                if (++this.count < 100) {
                    Pac.this.pacman.schedule.scheduleOnce(this);
                }
            }
        });
        this.pacman.schedule.scheduleOnceIn(300.0, new Steppable(){

            public void step(SimState state) {
                Pac.this.pacman.resetAgents();
            }
        });
    }
}

