/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import sim.app.pacman.Blinky;
import sim.app.pacman.Clyde;
import sim.app.pacman.Dot;
import sim.app.pacman.Energizer;
import sim.app.pacman.Inky;
import sim.app.pacman.IntPBMGrid2D;
import sim.app.pacman.Pac;
import sim.app.pacman.Pinky;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class PacMan
extends SimState {
    public Continuous2D agents;
    public Continuous2D dots;
    public IntPBMGrid2D maze;
    boolean frightenGhosts;
    public int[] actions;
    public int deaths = 0;
    public int level = 1;
    public int score = 0;
    public Pac[] pacs;
    public int MAX_MAZES = 2;

    public PacMan(long seed) {
        super(seed);
    }

    public void start() {
        super.start();
        this.deaths = 0;
        this.level = 1;
        this.score = 0;
        this.maze = new IntPBMGrid2D(PacMan.class.getResourceAsStream("images/maze0.pbm"));
        this.agents = new Continuous2D(1.0, this.maze.getWidth(), this.maze.getHeight());
        this.dots = new Continuous2D(1.0, this.maze.getWidth(), this.maze.getHeight());
        this.resetGame();
    }

    public void resetGame() {
        this.dots.clear();
        this.maze.read(PacMan.class.getResourceAsStream("images/maze" + (this.level - 1) % this.MAX_MAZES + ".pbm"));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(1.0, 5.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(26.0, 5.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(1.0, 25.0));
        this.dots.setObjectLocation((Object)new Energizer(), new Double2D(26.0, 25.0));
        for (int x = 0; x < this.maze.getWidth(); ++x) {
            for (int y = 0; y < this.maze.getHeight(); ++y) {
                if (this.maze.field[x][y] != 0 || y == 16 && x >= 12 && x <= 16) continue;
                this.dots.setObjectLocation((Object)new Dot(), new Double2D(x, y));
            }
        }
        this.resetAgents();
    }

    public int pacsLeft() {
        int count = 0;
        for (int i = 0; i < this.pacs.length; ++i) {
            if (this.pacs[i] == null) continue;
            ++count;
        }
        return count;
    }

    public Pac pacClosestTo(MutableDouble2D location) {
        if (this.pacs.length == 1) {
            return this.pacs[0];
        }
        Pac best = null;
        int count = 1;
        for (int i = 0; i < this.pacs.length; ++i) {
            block5: {
                block6: {
                    if (this.pacs[i] == null) continue;
                    if (best == null) break block5;
                    if (!(best.location.distanceSq(location) > this.pacs[i].location.distanceSq(location))) break block6;
                    count = 1;
                    if (true) break block5;
                }
                if (best.location.distanceSq(location) != this.pacs[i].location.distanceSq(location) || !this.random.nextBoolean(1.0 / (double)(++count))) continue;
            }
            best = this.pacs[i];
        }
        return best;
    }

    public void resetAgents() {
        this.agents.clear();
        this.schedule.clear();
        this.actions = new int[]{-1, -1};
        this.pacs = new Pac[2];
        if (this.pacs.length > 1) {
            this.pacs[1] = new Pac(this, 1);
        }
        this.pacs[0] = new Pac(this, 0);
        Blinky blinky = new Blinky(this);
        Pinky pinky = new Pinky(this);
        Inky inky = new Inky(this, blinky);
        Clyde clyde = new Clyde(this);
        this.frightenGhosts = false;
    }

    public int getNextAction(int tag) {
        return this.actions[tag];
    }

    public static void main(String[] args) {
        PacMan.doLoop(PacMan.class, args);
        System.exit(0);
    }
}

