/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import sim.app.pacman.Blinky;
import sim.app.pacman.Clyde;
import sim.app.pacman.Dot;
import sim.app.pacman.Energizer;
import sim.app.pacman.Inky;
import sim.app.pacman.MazeCellPortrayal;
import sim.app.pacman.Overlay;
import sim.app.pacman.Pac;
import sim.app.pacman.PacMan;
import sim.app.pacman.PacPortrayal;
import sim.app.pacman.Pinky;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.RateAdjuster;
import sim.display.SimpleController;
import sim.engine.SimState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.portrayal.simple.FacetedPortrayal2D;
import sim.portrayal.simple.ImagePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;

public class PacManWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    public double FRAMES_PER_SECOND = 60.0;
    ValueGridPortrayal2D mazePortrayal = new ValueGridPortrayal2D();
    ContinuousPortrayal2D agentPortrayal = new ContinuousPortrayal2D();
    ContinuousPortrayal2D dotPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new PacManWithUI().createController();
    }

    public PacManWithUI() {
        super(new PacMan(System.currentTimeMillis()));
    }

    public PacManWithUI(SimState state) {
        super(state);
    }

    public Controller createController() {
        SimpleController c = new SimpleController(this);
        c.pressPlay();
        return c;
    }

    public static String getName() {
        return "Pac Man";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        PacMan pacman = (PacMan)this.state;
        RectanglePortrayal2D scared = new RectanglePortrayal2D((Paint)Color.blue, 1.6);
        this.agentPortrayal.setField(pacman.agents);
        this.agentPortrayal.setPortrayalForClass(Pac.class, new PacPortrayal(pacman, Color.yellow){

            public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
                this.color = ((Pac)object).tag == 0 ? Color.yellow : Color.green;
                super.draw(object, graphics, info);
            }
        });
        this.agentPortrayal.setPortrayalForClass(Blinky.class, new FacetedPortrayal2D(new SimplePortrayal2D[]{new ImagePortrayal2D(this.getClass(), "images/blinkyu.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/blinkyl.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/blinkyd.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/blinkyr.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened2.png", 2.0)}));
        this.agentPortrayal.setPortrayalForClass(Pinky.class, new FacetedPortrayal2D(new SimplePortrayal2D[]{new ImagePortrayal2D(this.getClass(), "images/pinkyu.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/pinkyl.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/pinkyd.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/pinkyr.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened2.png", 2.0)}));
        this.agentPortrayal.setPortrayalForClass(Inky.class, new FacetedPortrayal2D(new SimplePortrayal2D[]{new ImagePortrayal2D(this.getClass(), "images/inkyu.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/inkyl.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/inkyd.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/inkyr.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened2.png", 2.0)}));
        this.agentPortrayal.setPortrayalForClass(Clyde.class, new FacetedPortrayal2D(new SimplePortrayal2D[]{new ImagePortrayal2D(this.getClass(), "images/clydeu.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/clydel.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/clyded.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/clyder.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened.png", 2.0), new ImagePortrayal2D(this.getClass(), "images/frightened2.png", 2.0)}));
        this.dotPortrayal.setField(pacman.dots);
        this.dotPortrayal.setPortrayalForClass(Energizer.class, new OvalPortrayal2D((Paint)Color.white, 1.0));
        this.dotPortrayal.setPortrayalForClass(Dot.class, new OvalPortrayal2D((Paint)Color.white, 0.4));
        this.mazePortrayal.setPortrayalForAll(new MazeCellPortrayal(pacman.maze));
        this.mazePortrayal.setField(pacman.maze);
        this.scheduleRepeatingImmediatelyAfter(new RateAdjuster(this.FRAMES_PER_SECOND));
        this.display.reset();
        this.display.repaint();
    }

    public void init(final Controller c) {
        super.init(c);
        this.display = new Display2D(448.0, 560.0, this){

            public void createConsoleMenu() {
            }

            public void quit() {
                super.quit();
                ((SimpleController)c).doClose();
            }
        };
        this.display.setBackdrop(Color.black);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("MASON Pac Man");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.mazePortrayal, "Maze");
        this.display.attach(this.dotPortrayal, "Dots", 8.0, 8.0, true);
        this.display.attach(this.agentPortrayal, "Agents", 8.0, 8.0, true);
        this.display.attach(new Overlay(this), "Overlay");
        this.display.remove(this.display.header);
        this.display.removeListeners();
        JScrollPane cfr_ignored_0 = this.display.display;
        this.display.display.setVerticalScrollBarPolicy(21);
        JScrollPane cfr_ignored_1 = this.display.display;
        this.display.display.setHorizontalScrollBarPolicy(31);
        this.displayFrame.setDefaultCloseOperation(2);
        this.displayFrame.setResizable(false);
        this.display.insideDisplay.setupHints(true, false, false);
        this.displayFrame.pack();
        this.addListeners(this.display);
    }

    public void addListeners(final Display2D display) {
        final PacMan pacman = (PacMan)this.state;
        final SimpleController cont = (SimpleController)this.controller;
        display.setFocusable(true);
        this.displayFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                display.requestFocusInWindow();
            }
        });
        display.requestFocusInWindow();
        display.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int c = e.getKeyCode();
                switch (c) {
                    case 38: {
                        pacman.actions[0] = 0;
                        break;
                    }
                    case 40: {
                        pacman.actions[0] = 2;
                        break;
                    }
                    case 37: {
                        pacman.actions[0] = 3;
                        break;
                    }
                    case 39: {
                        pacman.actions[0] = 1;
                        break;
                    }
                    case 87: {
                        pacman.actions[1] = 0;
                        break;
                    }
                    case 83: {
                        pacman.actions[1] = 2;
                        break;
                    }
                    case 65: {
                        pacman.actions[1] = 3;
                        break;
                    }
                    case 68: {
                        pacman.actions[1] = 1;
                        break;
                    }
                    case 82: {
                        cont.pressStop();
                        cont.pressPlay();
                        break;
                    }
                    case 80: {
                        cont.pressPause();
                        break;
                    }
                    case 77: {
                        if (cont.getPlayState() != 2) {
                            cont.pressPause();
                        }
                        cont.doNew();
                        display.requestFocusInWindow();
                    }
                }
            }
        });
    }

    public void quit() {
        super.quit();
        this.display = null;
        if (this.displayFrame != null) {
            JFrame f = this.displayFrame;
            this.displayFrame = null;
            f.dispose();
        }
    }
}

