/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import sim.app.pacman.Pac;
import sim.app.pacman.PacMan;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;

public class PacPortrayal
extends SimplePortrayal2D {
    protected Color color;
    PacMan pacman;
    public static final int MOUTH_RATE = 10;
    public static final double MAXIMUM_MOUTH_ANGLE = 60.0;
    Arc2D.Double arc = new Arc2D.Double();

    public PacPortrayal(PacMan pacman, Color color) {
        this.pacman = pacman;
        this.color = color;
    }

    public void draw(Object object, Graphics2D g, DrawInfo2D info) {
        Pac pac = (Pac)object;
        int time = (int)this.pacman.schedule.getTime();
        int step = time % 20;
        if (step > 10) {
            step = 10 - (step - 10);
        }
        double x = info.draw.x;
        double y = info.draw.y;
        double w = info.draw.width * 0.8;
        double a = 0.0;
        switch (pac.lastAction) {
            case 0: {
                a = 90.0;
                break;
            }
            case 1: {
                a = 0.0;
                break;
            }
            case 2: {
                a = -90.0;
                break;
            }
            case 3: {
                a = 180.0;
                break;
            }
            case -1: {
                a = 0.0;
            }
        }
        double starta = a - 60.0 * (double)step / 10.0;
        double enda = 120.0 * (double)step / 10.0 - 360.0;
        this.arc.setArcByCenter(x, y, w, starta, enda, 2);
        g.setColor(this.color);
        g.fill(this.arc);
    }
}

