/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso3d;

import sim.app.pso3d.Evaluatable3D;
import sim.app.pso3d.Griewangk3D;
import sim.app.pso3d.Particle3D;
import sim.app.pso3d.Rastrigin3D;
import sim.app.pso3d.Rosenbrock3D;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous3D;
import sim.util.MutableDouble3D;

public class PSO3D
extends SimState {
    public Continuous3D space;
    public double width = 10.24;
    public double height = 10.24;
    public double length = 10.24;
    public Particle3D[] particles;
    private int previousSuccessCount = -1;
    public int numParticles = 1000;
    public int neighborhoodSize = 10;
    public double initialVelocityRange = 1.0;
    public double velocityScalar = 2.7;
    public int fitnessFunction = 0;
    public double[] fitnessFunctionLowerBound = new double[]{950.0, 998.0, 200.0};
    public double successThreshold = 1.0E-8;
    public double bestVal = 0.0;
    MutableDouble3D bestPosition = new MutableDouble3D();

    public int getNumParticles() {
        return this.numParticles;
    }

    public void setNumParticles(int val) {
        if (val >= 0) {
            this.numParticles = val;
        }
    }

    public int getNeighborhoodSize() {
        return this.neighborhoodSize;
    }

    public void setNeighborhoodSize(int val) {
        if (val >= 0 && val <= this.numParticles) {
            this.neighborhoodSize = val;
        }
    }

    public double getInitialVelocityRange() {
        return this.initialVelocityRange;
    }

    public void setInitialVelocityRange(double val) {
        if (val >= 0.0) {
            this.initialVelocityRange = val;
        }
    }

    public double getVelocityScalar() {
        return this.velocityScalar;
    }

    public void setVelocityScalar(double val) {
        if (val >= 0.0) {
            this.velocityScalar = val;
        }
    }

    public int getFitnessFunction() {
        return this.fitnessFunction;
    }

    public void setFitnessFunction(int val) {
        this.fitnessFunction = val;
    }

    public Object domFitnessFunction() {
        return new String[]{"Rastrigin", "Griewangk", "Rosenbrock"};
    }

    private Evaluatable3D mapFitnessFunction(int val) {
        switch (val) {
            case 0: {
                return new Rastrigin3D();
            }
            case 1: {
                return new Griewangk3D();
            }
            case 2: {
                return new Rosenbrock3D();
            }
        }
        return new Rastrigin3D();
    }

    public double getSuccessThreshold() {
        return this.successThreshold;
    }

    public void setSuccessThreshold(double val) {
        if (val >= 0.0) {
            this.successThreshold = val;
        }
    }

    public PSO3D(long seed) {
        super(seed);
    }

    public void updateBest(double currVal, double currX, double currY, double currZ) {
        if (currVal > this.bestVal) {
            this.bestVal = currVal;
            this.bestPosition.setTo(currX, currY, currZ);
        }
    }

    public double getNeighborhoodBest(int index, MutableDouble3D pos) {
        double bv = Double.NEGATIVE_INFINITY;
        int start = index - this.neighborhoodSize / 2;
        if (start < 0) {
            start += this.numParticles;
        }
        for (int i = 0; i < this.neighborhoodSize; ++i) {
            Particle3D p = this.particles[(start + i) % this.numParticles];
            if (!(p.bestVal > bv)) continue;
            bv = p.bestVal;
            pos.setTo(p.bestPosition);
        }
        return 1.0;
    }

    public void start() {
        this.bestVal = 0.0;
        super.start();
        this.particles = new Particle3D[this.numParticles];
        this.space = new Continuous3D(1.0, this.length, this.width, this.height);
        Evaluatable3D f = this.mapFitnessFunction(this.fitnessFunction);
        for (int i = 0; i < this.numParticles; ++i) {
            Particle3D p;
            double x = this.random.nextDouble() * this.width - this.width * 0.5;
            double y = this.random.nextDouble() * this.height - this.height * 0.5;
            double z = this.random.nextDouble() * this.height - this.height * 0.5;
            double vx = this.random.nextDouble() * this.initialVelocityRange - this.initialVelocityRange * 0.5;
            double vy = this.random.nextDouble() * this.initialVelocityRange - this.initialVelocityRange * 0.5;
            double vz = this.random.nextDouble() * this.initialVelocityRange - this.initialVelocityRange * 0.5;
            this.particles[i] = p = new Particle3D(x, y, z, vx, vy, vz, this, f, i);
            this.schedule.scheduleRepeating(0.0, 1, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdateFitness();
                }
            });
            this.schedule.scheduleRepeating(0.0, 2, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdateVelocity();
                }
            });
            this.schedule.scheduleRepeating(0.0, 3, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdatePosition();
                }
            });
        }
        this.schedule.scheduleRepeating(0.0, 4, new Steppable(){

            public void step(SimState state) {
                int successCount = 0;
                for (int i = 0; i < PSO3D.this.space.allObjects.numObjs; ++i) {
                    Particle3D p = (Particle3D)PSO3D.this.space.allObjects.get(i);
                    if (!(Math.abs(p.getFitness() - 1000.0) <= PSO3D.this.successThreshold)) continue;
                    ++successCount;
                }
                if (successCount != PSO3D.this.previousSuccessCount) {
                    PSO3D.this.previousSuccessCount = successCount;
                }
                if (successCount == PSO3D.this.numParticles) {
                    state.kill();
                }
            }
        });
    }

    public static void main(String[] args) {
        PSO3D.doLoop(PSO3D.class, args);
        System.exit(0);
    }
}

