/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso3d;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import sim.app.pso3d.PSO3D;
import sim.app.pso3d.Particle3D;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.simple.CubePortrayal3D;
import sim.portrayal3d.simple.WireFrameBoxPortrayal3D;
import sim.util.gui.SimpleColorMap;

public class PSO3DWithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    ContinuousPortrayal3D swarmPortrayal = new ContinuousPortrayal3D();

    public static void main(String[] args) {
        new PSO3DWithUI().createController();
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public static String getName() {
        return "Particle Swarm Optimization 3D";
    }

    public PSO3DWithUI() {
        super(new PSO3D(System.currentTimeMillis()));
    }

    public PSO3DWithUI(SimState state) {
        super(state);
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        PSO3D swarm = (PSO3D)this.state;
        final SimpleColorMap map = new SimpleColorMap(swarm.fitnessFunctionLowerBound[swarm.fitnessFunction], 1000.0, Color.blue, Color.red);
        this.swarmPortrayal.setField(swarm.space);
        for (int x = 0; x < swarm.space.allObjects.numObjs; ++x) {
            final Particle3D p = (Particle3D)swarm.space.allObjects.objs[x];
            this.swarmPortrayal.setPortrayalForObject(p, new CubePortrayal3D(Color.green, 0.05f){

                public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
                    Appearance appearance = 1.appearanceForColor(map.getColor(p.getFitness()));
                    TransformGroup model = super.getModel(obj, j3dModel);
                    Shape3D shape = (Shape3D)model.getChild(0);
                    shape.setAppearance(appearance);
                    return model;
                }
            });
        }
        this.display.attach(new WireFrameBoxPortrayal3D(-5.12, -5.12, -5.12, 5.12, 5.12, 5.12), "Bounds");
        this.display.createSceneGraph();
        this.display.reset();
    }

    public void init(Controller c) {
        super.init(c);
        double w = 10.24;
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.swarmPortrayal, "Swarm");
        this.display.scale(1.0 / w);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("PSO 3D Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

