/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial3;

import sim.app.tutorial3.Tutorial3;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;
import sim.util.Int2D;

public class Particle
implements Steppable {
    public boolean randomize = false;
    public int xdir;
    public int ydir;

    public Particle(int xdir, int ydir) {
        this.xdir = xdir;
        this.ydir = ydir;
    }

    public void step(SimState state) {
        Tutorial3 tut = (Tutorial3)state;
        Int2D location = tut.particles.getObjectLocation(this);
        tut.trails.field[location.x][location.y] = 1.0;
        if (this.randomize) {
            this.xdir = tut.random.nextInt(3) - 1;
            this.ydir = tut.random.nextInt(3) - 1;
            this.randomize = false;
        }
        int newx = location.x + this.xdir;
        int newy = location.y + this.ydir;
        if (newx < 0) {
            ++newx;
            this.xdir = -this.xdir;
        } else if (newx >= tut.trails.getWidth()) {
            --newx;
            this.xdir = -this.xdir;
        }
        if (newy < 0) {
            ++newy;
            this.ydir = -this.ydir;
        } else if (newy >= tut.trails.getHeight()) {
            --newy;
            this.ydir = -this.ydir;
        }
        Int2D newloc = new Int2D(newx, newy);
        tut.particles.setObjectLocation((Object)this, newloc);
        Bag p = tut.particles.getObjectsAtLocation(newloc);
        if (p.numObjs > 1) {
            for (int x = 0; x < p.numObjs; ++x) {
                ((Particle)p.objs[x]).randomize = true;
            }
        }
    }
}

