/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial3;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.tutorial3.Tutorial3;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class Tutorial3WithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    SparseGridPortrayal2D particlesPortrayal = new SparseGridPortrayal2D();
    FastValueGridPortrayal2D trailsPortrayal = new FastValueGridPortrayal2D("Trail");

    public static void main(String[] args) {
        new Tutorial3WithUI().createController();
    }

    public Tutorial3WithUI() {
        super(new Tutorial3(System.currentTimeMillis()));
    }

    public Tutorial3WithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial3: Particles";
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.trailsPortrayal.setField(((Tutorial3)this.state).trails);
        this.trailsPortrayal.setMap(new SimpleColorMap(0.0, 1.0, Color.black, Color.white));
        this.particlesPortrayal.setField(((Tutorial3)this.state).particles);
        this.particlesPortrayal.setPortrayalForAll(new OvalPortrayal2D(Color.green));
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.setBackdrop(Color.black);
        this.display.attach(this.trailsPortrayal, "Trails");
        this.display.attach(this.particlesPortrayal, "Particles");
    }
}

