/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial5;

import java.awt.Color;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import sim.app.tutorial5.Band;
import sim.field.network.Edge;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.network.EdgeDrawInfo2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;

public class BandPortrayal2D
extends SimpleEdgePortrayal2D {
    NumberFormat strengthFormat = NumberFormat.getInstance();

    public BandPortrayal2D() {
        this.strengthFormat.setMinimumIntegerDigits(1);
        this.strengthFormat.setMaximumFractionDigits(2);
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        EdgeDrawInfo2D ei = (EdgeDrawInfo2D)info;
        Edge e = (Edge)object;
        int startX = (int)ei.draw.x;
        int startY = (int)ei.draw.y;
        int endX = (int)ei.secondPoint.x;
        int endY = (int)ei.secondPoint.y;
        int midX = (int)((ei.draw.x + ei.secondPoint.x) / 2.0);
        int midY = (int)((ei.draw.y + ei.secondPoint.y) / 2.0);
        graphics.setColor(Color.black);
        graphics.drawLine(startX, startY, endX, endY);
        graphics.setColor(Color.blue);
        graphics.setFont(this.labelFont);
        String information = this.strengthFormat.format(((Band)e.info).strength);
        int width = graphics.getFontMetrics().stringWidth(information);
        graphics.drawString(information, midX - width / 2, midY);
    }
}

