/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims3d;

import java.awt.Color;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import sim.app.woims3d.Vector3D;
import sim.app.woims3d.WoimsDemo3D;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.simple.SpherePortrayal3D;
import sim.util.Bag;
import sim.util.Double3D;

public class Woim3D
extends SimplePortrayal3D
implements Steppable {
    public static final double CENTROID_DISTANCE = 20.0;
    public static final double AVOID_DISTANCE = 16.0;
    public static final double COPY_SPEED_DISTANCE = 40.0;
    public static final double OBSTACLE_AVOID_COEF = 1.05;
    public static final double OBSTACLE_FAST_AVOID_COEF = 1.5;
    public static final double MAX_DISTANCE = Math.max(20.0, Math.max(16.0, 40.0));
    public static final double ADJUSTMENT_RATE = 0.025;
    public static final double MIN_VELOCITY = 0.25;
    public static final double MAX_VELOCITY = 0.75;
    Bag nearbyWoims;
    double[] distSqrTo;
    double ond;
    double ondSpeed;
    protected Vector3D woimPosition = new Vector3D(0.0, 0.0, 0.0);
    public double x;
    public double y;
    public double z;
    static final int numLinks = 15;
    Vector3d[] lastPos = new Vector3d[15];
    Vector3d[] lastPosRel = new Vector3d[15];
    Color[] colors = new Color[15];
    protected double orientation;
    protected Vector3D velocity = new Vector3D(0.0, 0.0, 0.0);
    protected Vector3D acceleration = new Vector3D(0.0, 0.0, 0.0);
    public static final float SKIP = 10.0f;

    public Woim3D() {
        this.ond = Math.random() * 6.2832;
        this.ondSpeed = 0.05 + Math.random() * 0.15;
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(63 + 192 * (this.colors.length - i) / this.colors.length, 0, 0);
        }
        this.velocity = new Vector3D(0.05, 0.05, 0.05);
        this.computePositions();
    }

    public final double distanceSquared(Vector3D loc1, Vector3D loc2) {
        return (loc1.x - loc2.x) * (loc1.x - loc2.x) + (loc1.y - loc2.y) * (loc1.y - loc2.y) + (loc1.z - loc2.z) * (loc1.z - loc2.z);
    }

    public final double distanceSquared(Vector3D loc1, Double3D loc2) {
        return (loc1.x - loc2.x) * (loc1.x - loc2.x) + (loc1.y - loc2.y) * (loc1.y - loc2.y) + (loc1.z - loc2.z) * (loc1.z - loc2.z);
    }

    public final double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    void preprocessWoims(WoimsDemo3D state, Double3D pos, double distance) {
        this.nearbyWoims = state.woimEnvironment.getObjectsWithinDistance(pos, distance);
        if (this.nearbyWoims == null) {
            return;
        }
        this.distSqrTo = new double[this.nearbyWoims.numObjs];
        for (int i = 0; i < this.nearbyWoims.numObjs; ++i) {
            Woim3D p = (Woim3D)this.nearbyWoims.objs[i];
            this.distSqrTo[i] = this.distanceSquared(pos.x, pos.y, pos.z, p.x, p.y, p.z);
        }
    }

    public Vector3D towardsFlockCenterOfMass(WoimsDemo3D state) {
        if (this.nearbyWoims == null) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        Vector3D mean = new Vector3D(0.0, 0.0, 0.0);
        int n = 0;
        for (int i = 0; i < this.nearbyWoims.numObjs; ++i) {
            if (this.nearbyWoims.objs[i] == this || !(this.distSqrTo[i] <= 400.0) || !(this.distSqrTo[i] > 256.0)) continue;
            Woim3D p = (Woim3D)this.nearbyWoims.objs[i];
            mean = mean.add(new Double3D(p.x, p.y, p.z));
            ++n;
        }
        if (n == 0) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        mean = mean.amplify(1.0 / (double)n);
        mean = mean.subtract(this.woimPosition);
        return mean.normalize();
    }

    public Vector3D awayFromCloseBys(WoimsDemo3D state) {
        if (this.nearbyWoims == null) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        Vector3D away = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < this.nearbyWoims.numObjs; ++i) {
            if (this.nearbyWoims.objs[i] == this || !(this.distSqrTo[i] <= 256.0)) continue;
            Woim3D p = (Woim3D)this.nearbyWoims.objs[i];
            Vector3D temp = this.woimPosition.subtract(new Double3D(p.x, p.y, p.z));
            temp = temp.normalize();
            away = away.add(temp);
        }
        return away.normalize();
    }

    public Vector3D matchFlockSpeed(SimState state) {
        if (this.nearbyWoims == null) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        Vector3D mean = new Vector3D(0.0, 0.0, 0.0);
        int n = 0;
        for (int i = 0; i < this.nearbyWoims.numObjs; ++i) {
            if (this.nearbyWoims.objs[i] == this || !(this.distSqrTo[i] <= 1600.0) || !(this.distSqrTo[i] > 256.0)) continue;
            mean = mean.add(((Woim3D)this.nearbyWoims.objs[i]).velocity);
            ++n;
        }
        if (n == 0) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        mean = mean.amplify(1.0 / (double)n);
        return mean.normalize();
    }

    public Vector3D randomDirection(SimState state) {
        Vector3D temp = new Vector3D(1.0 - 2.0 * state.random.nextDouble(), 1.0 - 2.0 * state.random.nextDouble(), 1.0 - 2.0 * state.random.nextDouble());
        return temp.setLength(0.25 + state.random.nextDouble() * 0.5);
    }

    public Vector3D niceUndulation(SimState state) {
        this.ond += this.ondSpeed;
        if (this.ond > 7.0) {
            this.ond -= 6.2832;
        }
        double angle = Math.cos(this.ond);
        Vector3D temp = this.velocity;
        double velA = Math.atan2(temp.y, temp.x);
        return new Vector3D(Math.cos(velA += 1.5708 * angle), Math.sin(velA), 0.0);
    }

    public Vector3D avoidObstacles(SimState state) {
        double[][] info = WoimsDemo3D.obstInfo;
        if (info == null || info.length == 0) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        Vector3D away = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < info.length; ++i) {
            double dist = Math.sqrt((this.woimPosition.x - info[i][1]) * (this.woimPosition.x - info[i][1]) + (this.woimPosition.y - info[i][2]) * (this.woimPosition.y - info[i][2]) + (this.woimPosition.z - info[i][3]) * (this.woimPosition.z - info[i][3]));
            if (!(dist <= info[i][0] + 16.0)) continue;
            Vector3D temp = this.woimPosition.subtract(new Vector3D(info[i][1], info[i][2], info[i][3]));
            temp = temp.normalize();
            away = away.add(temp);
        }
        return away.normalize();
    }

    public void step(SimState state) {
        double vl;
        WoimsDemo3D bd = (WoimsDemo3D)state;
        Double3D temp = new Double3D(this.x, this.y, this.z);
        this.woimPosition.x = this.x;
        this.woimPosition.y = this.y;
        this.woimPosition.z = this.z;
        this.preprocessWoims(bd, temp, MAX_DISTANCE);
        Vector3D vel = new Vector3D(0.0, 0.0, 0.0);
        vel = vel.add(this.avoidObstacles(bd).amplify(1.5));
        vel = vel.add(this.towardsFlockCenterOfMass(bd).amplify(0.5));
        vel = vel.add(this.matchFlockSpeed(bd).amplify(0.5));
        vel = vel.add(this.awayFromCloseBys(bd).amplify(1.5));
        if (vel.length() <= 1.0) {
            vel = vel.add(this.niceUndulation(bd).amplify(0.5));
            vel = vel.add(this.randomDirection(bd).amplify(0.25));
        }
        if ((vl = vel.length()) < 0.25) {
            vel = vel.setLength(0.25);
        } else if (vl > 0.75) {
            vel = vel.setLength(0.75);
        }
        this.velocity = vel = new Vector3D(0.975 * this.velocity.x + 0.025 * vel.x, 0.975 * this.velocity.y + 0.025 * vel.y, 0.975 * this.velocity.z + 0.025 * vel.z);
        Double3D desiredPosition = new Double3D(this.woimPosition.x + vel.x * 30.0, this.woimPosition.y + vel.y * 30.0, this.woimPosition.z + vel.z * 30.0);
        bd.setObjectLocation(this, desiredPosition);
    }

    public void computePositions() {
        int i;
        double centerx = this.x + 0.5;
        double centery = this.y + 0.5;
        double centerz = this.z + 0.5;
        this.lastPos[0] = new Vector3d(centerx, centery, centerz);
        Vector3d temp = new Vector3d();
        Vector3d velocity3d = new Vector3d(this.velocity.x, this.velocity.y, this.velocity.z);
        for (i = 1; i < 15; ++i) {
            if (this.lastPos[i] == null) {
                temp.scale(-1.0, (Tuple3d)velocity3d);
                temp.normalize();
                centerx = this.lastPos[i - 1].x + temp.x;
                centery = this.lastPos[i - 1].y + temp.y;
                centerz = this.lastPos[i - 1].z + temp.z;
                this.lastPos[i] = new Vector3d(centerx, centery, centerz);
                continue;
            }
            temp.sub((Tuple3d)this.lastPos[i - 1], (Tuple3d)this.lastPos[i]);
            temp.scale(10.0 / temp.length());
            temp.sub((Tuple3d)this.lastPos[i - 1], (Tuple3d)temp);
            this.lastPos[i] = new Vector3d(temp.x, temp.y, temp.z);
        }
        for (i = 0; i < this.lastPosRel.length; ++i) {
            this.lastPosRel[i] = new Vector3d(this.lastPos[i].x - this.lastPos[0].x, this.lastPos[i].y - this.lastPos[0].y, this.lastPos[i].z - this.lastPos[0].z);
        }
    }

    public TransformGroup createModel(Object obj) {
        TransformGroup globalTG = new TransformGroup();
        for (int i = 0; i < 15; ++i) {
            SpherePortrayal3D s = new SpherePortrayal3D(this.colors[i], 4.0, 6);
            s.setCurrentFieldPortrayal(this.getCurrentFieldPortrayal());
            TransformGroup localTG = s.getModel(obj, null);
            localTG.setCapability(18);
            globalTG.addChild((Node)localTG);
        }
        globalTG.setCapability(12);
        return globalTG;
    }

    public TransformGroup getModel(Object obj, TransformGroup transf) {
        this.computePositions();
        if (transf == null) {
            return this.createModel(obj);
        }
        for (int i = 0; i < transf.numChildren(); ++i) {
            Transform3D tmpT3d = new Transform3D();
            tmpT3d.setTranslation(this.lastPosRel[i]);
            ((TransformGroup)transf.getChild(i)).setTransform(tmpT3d);
        }
        return transf;
    }
}

