/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import ec.util.MersenneTwisterFast;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OptionalDataException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import sim.display.Console;
import sim.display.Controller;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.portrayal.SimpleInspector;
import sim.util.Properties;

public abstract class GUIState {
    public MersenneTwisterFast guirandom = new MersenneTwisterFast();
    public SimState state;
    public Controller controller;
    public HashMap storage = new HashMap();
    boolean started = false;
    protected Steppable[] before;
    Steppable[] before2;
    protected int beforeSize;
    protected Steppable[] after;
    Steppable[] after2;
    protected int afterSize;
    Steppable[] start;
    Steppable[] start2;
    int startSize;
    Steppable[] finish;
    Steppable[] finish2;
    int finishSize;

    private GUIState() {
    }

    public GUIState(SimState state) {
        this.state = state;
        this.resetQueues();
    }

    public static String getTruncatedName(Class theClass) {
        if (theClass == null) {
            return "";
        }
        String fullName = theClass.getName();
        int lastPeriod = fullName.lastIndexOf(".");
        return fullName.substring(lastPeriod + 1);
    }

    public static final String getName(Class theClass) {
        if (theClass == null) {
            return "";
        }
        try {
            Method m = theClass.getMethod("getName", null);
            if (m.getDeclaringClass().equals(GUIState.class)) {
                return GUIState.getTruncatedName(theClass);
            }
            return (String)m.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return GUIState.getTruncatedName(theClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "Error in retrieving simulation name";
        }
    }

    public Controller createController() {
        Console console = new Console(this);
        console.setVisible(true);
        return console;
    }

    public static String getName() {
        return "This is GUIState's getName() method.  It probably shouldn't have been called.";
    }

    static Object doDefaultInfo(Class theClass) {
        URL url = theClass.getResource("index.html");
        if (url == null) {
            return "<html><head><title></title></head><body bgcolor=\"white\"></body></html>";
        }
        return url;
    }

    public static final Object getInfo(Class theClass) {
        if (theClass == null) {
            return "";
        }
        try {
            Method m = theClass.getMethod("getInfo", null);
            if (m.getDeclaringClass().equals(GUIState.class)) {
                return GUIState.doDefaultInfo(theClass);
            }
            return m.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return GUIState.doDefaultInfo(theClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "Error in retrieving simulation info";
        }
    }

    public static Object getInfo() {
        return "This is GUIState's getInfo() method.  It probably shouldn't have been called.";
    }

    public Properties getSimulationProperties() {
        return null;
    }

    public int getMaximumPropertiesForInspector() {
        return 25;
    }

    public Inspector getInspector() {
        Object object = this.getSimulationInspectedObject();
        if (object != null) {
            SimpleInspector i = new SimpleInspector(object, this, null, this.getMaximumPropertiesForInspector());
            ((Inspector)i).setVolatile(false);
            return i;
        }
        Properties prop = this.getSimulationProperties();
        if (prop != null) {
            SimpleInspector i = new SimpleInspector(prop, this, null, this.getMaximumPropertiesForInspector());
            ((Inspector)i).setVolatile(true);
            return i;
        }
        return null;
    }

    public Object getSimulationInspectedObject() {
        return null;
    }

    public boolean isInspectorVolatile() {
        return this.getInspector().isVolatile();
    }

    public void init(Controller controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.started = true;
        this.state.start();
        Schedule schedule = this.state.schedule;
        synchronized (schedule) {
            Steppable[] _start2 = this.start2;
            System.arraycopy(this.start, 0, this.start2, 0, this.startSize);
            int _startSize = this.startSize;
            this.startSize = 0;
            for (int x = 0; x < _startSize; ++x) {
                _start2[x].step(this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (!this.started) {
            return;
        }
        Schedule schedule = this.state.schedule;
        synchronized (schedule) {
            Steppable[] _finish2 = this.finish2;
            System.arraycopy(this.finish, 0, this.finish2, 0, this.finishSize);
            int _finishSize = this.finishSize;
            this.finishSize = 0;
            for (int x = 0; x < _finishSize; ++x) {
                _finish2[x].step(this.state);
            }
        }
        this.state.finish();
        this.resetQueues();
        this.started = false;
    }

    public void quit() {
    }

    public boolean validSimState(SimState state) {
        return state != null && state.getClass().equals(this.state.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SimState state) {
        this.state = state;
        this.started = true;
        Schedule schedule = state.schedule;
        synchronized (schedule) {
            Steppable[] _start2 = this.start2;
            System.arraycopy(this.start, 0, this.start2, 0, this.startSize);
            int _startSize = this.startSize;
            this.startSize = 0;
            for (int x = 0; x < _startSize; ++x) {
                _start2[x].step(state);
            }
        }
    }

    public boolean readNewStateFromCheckpoint(File file) throws IOException, ClassNotFoundException, OptionalDataException, ClassCastException, Exception {
        FileInputStream f = new FileInputStream(file);
        SimState state = SimState.readFromCheckpoint(f);
        f.close();
        if (!this.validSimState(state)) {
            return false;
        }
        this.finish();
        this.load(state);
        return true;
    }

    protected void resetQueues() {
        this.before = new Steppable[11];
        this.before2 = new Steppable[11];
        this.beforeSize = 0;
        this.after = new Steppable[11];
        this.after2 = new Steppable[11];
        this.afterSize = 0;
        this.start = new Steppable[11];
        this.start2 = new Steppable[11];
        this.startSize = 0;
        this.finish = new Steppable[11];
        this.finish2 = new Steppable[11];
        this.finishSize = 0;
    }

    private final synchronized void reset(SimState state) {
        state.schedule.reset();
        this.resetQueues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step() {
        boolean returnval = false;
        Schedule schedule = this.state.schedule;
        synchronized (schedule) {
            int x;
            Steppable[] _before2 = this.before2;
            Steppable[] _after2 = this.after2;
            System.arraycopy(this.before, 0, this.before2, 0, this.beforeSize);
            System.arraycopy(this.after, 0, this.after2, 0, this.afterSize);
            int _beforeSize = this.beforeSize;
            int _afterSize = this.afterSize;
            this.afterSize = 0;
            this.beforeSize = 0;
            for (x = 0; x < _beforeSize; ++x) {
                _before2[x].step(this.state);
            }
            returnval = this.state.schedule.step(this.state);
            for (x = 0; x < _afterSize; ++x) {
                _after2[x].step(this.state);
            }
        }
        return returnval;
    }

    protected Steppable[] increaseSubsteps(Steppable[] substeps) {
        Steppable[] newsubstep = new Steppable[substeps.length * 2 + 1];
        System.arraycopy(substeps, 0, newsubstep, 0, substeps.length);
        return newsubstep;
    }

    public boolean scheduleImmediatelyBefore(Steppable event) {
        return this._scheduleImmediate(false, event);
    }

    public boolean scheduleImmediatelyAfter(Steppable event) {
        return this._scheduleImmediate(true, event);
    }

    public boolean scheduleImmediate(boolean immediatelyAfter, Steppable event) {
        return this._scheduleImmediate(immediatelyAfter, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _scheduleImmediate(boolean immediatelyAfter, Steppable event) {
        Schedule schedule = this.state.schedule;
        synchronized (schedule) {
            if (event == null || this.state.schedule.getTime() >= Double.POSITIVE_INFINITY) {
                if (event == null) {
                    throw new IllegalArgumentException("The provided Steppable is null");
                }
                if (this.state.schedule.getTime() >= Double.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("The simulation is over and the item cannot be scheduled.");
                }
            }
            if (immediatelyAfter) {
                if (this.afterSize == this.after.length) {
                    this.after = this.increaseSubsteps(this.after);
                    this.after2 = new Steppable[this.after.length];
                }
                this.after[this.afterSize++] = event;
            } else {
                if (this.beforeSize == this.before.length) {
                    this.before = this.increaseSubsteps(this.before);
                    this.before2 = new Steppable[this.before.length];
                }
                this.before[this.beforeSize++] = event;
            }
        }
        return true;
    }

    public Stoppable scheduleRepeatingImmediatelyBefore(Steppable event) {
        return this._scheduleImmediateRepeat(false, event);
    }

    public Stoppable scheduleRepeatingImmediatelyAfter(Steppable event) {
        return this._scheduleImmediateRepeat(true, event);
    }

    public Stoppable scheduleImmediateRepeat(boolean immediatelyAfter, Steppable event) {
        return this._scheduleImmediateRepeat(immediatelyAfter, event);
    }

    Stoppable _scheduleImmediateRepeat(boolean immediatelyAfter, Steppable event) {
        Repeat r = new Repeat(immediatelyAfter, event);
        if (this.scheduleImmediate(immediatelyAfter, r)) {
            return r;
        }
        return null;
    }

    public boolean scheduleAtExtreme(Steppable event, boolean atEnd) {
        return this._scheduleAtExtreme(event, atEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _scheduleAtExtreme(Steppable event, boolean atEnd) {
        Schedule schedule = this.state.schedule;
        synchronized (schedule) {
            if (event == null || this.state.schedule.getTime() >= Double.POSITIVE_INFINITY) {
                if (event == null) {
                    throw new IllegalArgumentException("The provided Steppable is null");
                }
                if (this.state.schedule.getTime() >= Double.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("The simulation is over and the item cannot be scheduled.");
                }
            }
            if (atEnd) {
                if (this.finishSize == this.finish.length) {
                    this.finish = this.increaseSubsteps(this.finish);
                    this.finish2 = new Steppable[this.finish.length];
                }
                this.finish[this.finishSize++] = event;
            } else {
                if (this.startSize == this.start.length) {
                    this.start = this.increaseSubsteps(this.start);
                    this.start2 = new Steppable[this.start.length];
                }
                this.start[this.startSize++] = event;
            }
        }
        return true;
    }

    public boolean scheduleAtStart(Steppable event) {
        return this._scheduleAtExtreme(event, false);
    }

    public boolean scheduleAtEnd(Steppable event) {
        return this._scheduleAtExtreme(event, true);
    }

    class Repeat
    implements Steppable,
    Stoppable {
        protected boolean immediatelyAfter;
        protected Steppable step;

        public Repeat(boolean immediatelyAfter, Steppable step) {
            this.immediatelyAfter = immediatelyAfter;
            this.step = step;
        }

        public synchronized void step(SimState state) {
            if (this.step != null) {
                try {
                    GUIState.this.scheduleImmediate(this.immediatelyAfter, this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.step.step(state);
            }
        }

        public synchronized void stop() {
            this.step = null;
        }
    }
}

