/*
 * Decompiled with CFR 0.152.
 */
package sim.display3d;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;

public class CapturingCanvas3D
extends Canvas3D {
    boolean writeBuffer_;
    boolean keepOnWriting_;
    BufferedImage buffer_;
    int x;
    int y;
    int width;
    int height;

    public CapturingCanvas3D(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public CapturingCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
        super(graphicsConfiguration, offScreen);
    }

    public synchronized BufferedImage getLastImage() {
        return this.buffer_;
    }

    Rectangle2D getImageSize() {
        Dimension s = this.getSize();
        Rectangle2D clip = new Rectangle2D.Double(0.0, 0.0, s.width, s.height);
        Rectangle bounds = this.getGraphics().getClipBounds();
        if (bounds != null) {
            clip = ((Rectangle2D)clip).createIntersection(bounds);
        }
        return clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCapturing(boolean movie) {
        Rectangle2D r = this.getImageSize();
        CapturingCanvas3D capturingCanvas3D = this;
        synchronized (capturingCanvas3D) {
            this.x = (int)r.getX();
            this.y = (int)r.getY();
            this.width = (int)r.getWidth();
            this.height = (int)r.getHeight();
            this.writeBuffer_ = true;
            this.keepOnWriting_ |= movie;
        }
        this.fillBuffer(true);
    }

    void fillBuffer(boolean doubleRasterRead) {
        GraphicsContext3D ctx = this.getGraphicsContext3D();
        Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, this.x, this.y, this.width, this.height, new ImageComponent2D(1, new BufferedImage(this.width, this.height, 1)), null);
        ctx.readRaster(ras);
        if (doubleRasterRead) {
            ctx.readRaster(ras);
        }
        this.buffer_ = ras.getImage().getImage();
        this.buffer_.flush();
    }

    public synchronized void stopCapturing() {
        this.keepOnWriting_ = false;
    }

    public void postSwap() {
        if (this.writeBuffer_) {
            this.fillBuffer(false);
            if (!this.keepOnWriting_) {
                this.writeBuffer_ = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRender() {
        CapturingCanvas3D capturingCanvas3D = this;
        synchronized (capturingCanvas3D) {
            ((Object)((Object)this)).notify();
        }
    }
}

