/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;

public abstract class AsynchronousSteppable
implements Stoppable {
    Thread thread;
    boolean running = false;
    boolean paused = false;
    protected SimState state;

    protected abstract void run(boolean var1);

    protected abstract void halt(boolean var1);

    public final synchronized void step(SimState state) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.state = state;
        state.addToAsynchronousRegistry(this);
        this.thread = new Thread(new Runnable(){

            public void run() {
                AsynchronousSteppable.this.run(false);
            }
        });
        this.thread.setDaemon(true);
        this.thread.setName("Asynchronous Steppable: " + this);
        this.thread.start();
    }

    public final synchronized void stop() {
        boolean joined = false;
        if (!this.running) {
            return;
        }
        this.halt(false);
        while (!joined) {
            try {
                this.thread.join();
                joined = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.state.removeFromAsynchronousRegistry(this);
        this.running = false;
    }

    public final synchronized void pause() {
        boolean joined = false;
        if (this.paused || !this.running) {
            return;
        }
        this.halt(true);
        while (!joined) {
            try {
                this.thread.join();
                joined = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.paused = true;
    }

    public final synchronized void resume() {
        if (!this.paused || !this.running) {
            return;
        }
        this.paused = false;
        this.thread = new Thread(new Runnable(){

            public void run() {
                AsynchronousSteppable.this.run(true);
            }
        });
        this.thread.start();
    }

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeBoolean(this.running);
        p.writeBoolean(this.paused);
        p.writeObject(this.state);
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.running = p.readBoolean();
        this.paused = p.readBoolean();
        this.state = (SimState)p.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    public final Steppable stopper() {
        return new Steppable(){

            public void step(SimState state) {
                AsynchronousSteppable.this.stop();
            }
        };
    }
}

