/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import sim.engine.SimState;
import sim.engine.Steppable;

public class MultiStep
implements Steppable {
    int current;
    final boolean countdown;
    final int n;
    final Steppable step;

    public MultiStep(Steppable step, int n, boolean countdown) {
        if (n < 0) {
            n = 0;
        }
        this.n = n;
        this.step = step;
        this.countdown = countdown;
        this.current = n;
    }

    public synchronized void resetCountdown() {
        this.current = this.n;
    }

    synchronized boolean go() {
        if (--this.current == 0) {
            this.current = this.n;
            return true;
        }
        return false;
    }

    public void step(SimState state) {
        if (this.n != 0) {
            if (this.countdown) {
                if (this.go()) {
                    this.step.step(state);
                }
            } else {
                for (int x = 0; x < this.n; ++x) {
                    this.step.step(state);
                }
            }
        }
    }
}

