/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;

public class ParallelSequence
extends Sequence {
    Semaphore semaphore = new Semaphore(0);
    Worker[] workers;
    Thread[] threads;
    boolean pleaseDie = false;
    boolean operating = false;
    boolean destroysThreads = false;
    static int availableProcessors = Runtime.getRuntime().availableProcessors();
    public static final int CPUS = -1;
    static final long serialVersionUID = 2731888904476273479L;

    public boolean getDestroysThreads() {
        return this.destroysThreads;
    }

    public void setDestroysThreads(boolean val) {
        this.destroysThreads = val;
    }

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeObject(this.semaphore);
        p.writeObject(this.workers);
        p.writeBoolean(this.pleaseDie);
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.semaphore = (Semaphore)p.readObject();
        this.workers = (Worker[])p.readObject();
        this.pleaseDie = p.readBoolean();
        this.buildThreads();
    }

    void buildThreads() {
        this.threads = new Thread[this.steps.length];
        for (int i = 0; i < this.steps.length; ++i) {
            this.threads[i] = new Thread(this.workers[i]);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
    }

    void gatherThreads() {
        int x;
        this.pleaseDie = true;
        for (x = 0; x < this.steps.length; ++x) {
            this.workers[x].V();
        }
        for (x = 0; x < this.steps.length; ++x) {
            try {
                this.threads[x].join();
                continue;
            }
            catch (InterruptedException e) {
                --x;
            }
        }
        this.pleaseDie = false;
        this.threads = null;
    }

    public Steppable getCleaner() {
        return new Steppable(){

            public void step(SimState state) {
                ParallelSequence.this.gatherThreads();
            }
        };
    }

    public void cleanup() {
        this.gatherThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public ParallelSequence(Steppable[] sequence, int threads) {
        super(sequence);
        if (threads == -1) {
            threads = availableProcessors;
        }
        if (threads < sequence.length) {
            this.steps = new Steppable[threads];
            int len = sequence.length / threads;
            if (len * threads < sequence.length) {
                ++len;
            }
            for (int i = 0; i < threads; ++i) {
                int start = i * len;
                if (len > sequence.length - start) {
                    len = sequence.length - start;
                }
                Steppable[] currentSteppable = new Steppable[len];
                System.arraycopy(sequence, start, currentSteppable, 0, len);
                this.steps[i] = new Sequence(currentSteppable);
            }
        }
        this.workers = new Worker[this.steps.length];
        for (int i = 0; i < this.steps.length; ++i) {
            this.workers[i] = new Worker();
        }
        this.buildThreads();
    }

    public ParallelSequence(Steppable[] steps) {
        this(steps, steps.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step(SimState state) {
        Worker[] workerArray = this.workers;
        synchronized (this.workers) {
            int x;
            if (this.operating) {
                throw new RuntimeException("ParallelSequence stepped, but it's already in progress.\nProbably you have the same ParallelSequence nested, or the same ParallelSequence being stepped in parallel.\nEither way, it's a bug.");
            }
            this.operating = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.threads == null) {
                this.buildThreads();
            }
            for (x = 0; x < this.steps.length; ++x) {
                this.workers[x].step = this.steps[x];
                this.workers[x].state = state;
                this.workers[x].V();
            }
            for (x = 0; x < this.steps.length; ++x) {
                this.semaphore.P();
            }
            if (this.destroysThreads) {
                this.cleanup();
            }
            this.operating = false;
            return;
        }
    }

    class Worker
    extends Semaphore
    implements Runnable {
        Steppable step;
        SimState state;
        static final long serialVersionUID = -7832866872102525417L;

        public Worker() {
            super(0);
        }

        public void run() {
            while (true) {
                this.P();
                if (ParallelSequence.this.pleaseDie) {
                    return;
                }
                Thread.currentThread().setName("Parallel Sequence: " + this.step);
                this.step.step(this.state);
                ParallelSequence.this.semaphore.V();
            }
        }
    }

    static class Semaphore
    implements Serializable {
        private int count;

        public Semaphore(int c) {
            this.count = c;
        }

        public synchronized void V() {
            if (this.count == 0) {
                this.notify();
            }
            ++this.count;
        }

        public synchronized void P() {
            while (this.count == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.count;
        }
    }
}

