/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import sim.engine.Schedule;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;

public class RandomSequence
extends Sequence {
    final boolean shouldSynchronize;

    public RandomSequence(Steppable[] steps) {
        this(steps, false);
    }

    public RandomSequence(Steppable[] steps, boolean shouldSynchronize) {
        super(steps);
        this.shouldSynchronize = shouldSynchronize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextInt(SimState state, int n) {
        Schedule schedule = state.schedule;
        synchronized (schedule) {
            return state.random.nextInt(n);
        }
    }

    public void step(SimState state) {
        boolean shouldSynchronize = this.shouldSynchronize;
        for (int x = this.steps.length - 1; x >= 1; --x) {
            int i = shouldSynchronize ? this.nextInt(state, x + 1) : state.random.nextInt(x + 1);
            Steppable temp = this.steps[i];
            this.steps[i] = this.steps[x];
            this.steps[x] = temp;
        }
        super.step(state);
    }
}

