/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import ec.util.MersenneTwisterFast;
import java.io.Serializable;
import sim.engine.Repeat;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Bag;
import sim.util.Heap;

public class Schedule
implements Serializable {
    public static final double EPOCH = 0.0;
    public static final double BEFORE_SIMULATION = -1.0;
    public static final double AFTER_SIMULATION = Double.POSITIVE_INFINITY;
    public static final double EPOCH_PLUS_EPSILON = Double.longBitsToDouble(Double.doubleToRawLongBits(0.0) + 1L);
    public static final double MAXIMUM_INTEGER = 9.007199254740992E15;
    boolean shuffling = true;
    Heap queue = this.createHeap();
    double time = -1.0;
    long steps = 0L;
    boolean sealed = false;
    protected Object lock = new boolean[1];
    Bag currentSteps = new Bag();
    Bag substeps = new Bag();
    boolean inStep = false;

    protected Heap createHeap() {
        return new Heap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setShuffling(boolean val) {
        Object object = this.lock;
        synchronized (object) {
            this.shuffling = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShuffling() {
        Object object = this.lock;
        synchronized (object) {
            return this.shuffling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double time() {
        Object object = this.lock;
        synchronized (object) {
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSealed() {
        Object object = this.lock;
        synchronized (object) {
            return this.sealed;
        }
    }

    public String getTimestamp(String beforeSimulationString, String afterSimulationString) {
        return this.getTimestamp(this.getTime(), beforeSimulationString, afterSimulationString);
    }

    public String getTimestamp(double time, String beforeSimulationString, String afterSimulationString) {
        if (time < 0.0) {
            return beforeSimulationString;
        }
        if (time >= Double.POSITIVE_INFINITY) {
            return afterSimulationString;
        }
        if (time == (double)((long)time)) {
            return Long.toString((long)time);
        }
        return Double.toString(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSteps() {
        Object object = this.lock;
        synchronized (object) {
            return this.steps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushToAfterSimulation() {
        Object object = this.lock;
        synchronized (object) {
            this.time = Double.POSITIVE_INFINITY;
            this.queue = this.createHeap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.queue = this.createHeap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seal() {
        Object object = this.lock;
        synchronized (object) {
            this.sealed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.time = -1.0;
            this.steps = 0L;
            this.queue = this.createHeap();
            this.sealed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleComplete() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean step(SimState state) {
        if (this.inStep) {
            throw new RuntimeException("Schedule.step() is not reentrant, yet is being called recursively.");
        }
        this.inStep = true;
        Bag currentSteps = this.currentSteps;
        MersenneTwisterFast random = state.random;
        int topSubstep = 0;
        Object object = this.lock;
        synchronized (object) {
            Key currentKey;
            if (this.time == Double.POSITIVE_INFINITY || this.queue.isEmpty()) {
                this.time = Double.POSITIVE_INFINITY;
                this.inStep = false;
                return false;
            }
            this.time = ((Key)this.queue.getMinKey()).time;
            boolean shuffling = this.shuffling;
            do {
                this.queue.extractMin(this.substeps);
                if (this.substeps.numObjs > 1) {
                    if (shuffling) {
                        this.substeps.shuffle(random);
                    } else {
                        this.substeps.reverse();
                    }
                }
                if (topSubstep < this.substeps.numObjs) {
                    topSubstep = this.substeps.numObjs;
                }
                currentSteps.addAll(this.substeps);
                this.substeps.numObjs = 0;
            } while ((currentKey = (Key)this.queue.getMinKey()) != null && currentKey.time == this.time);
        }
        this.substeps.numObjs = topSubstep;
        this.substeps.clear();
        int len = currentSteps.numObjs;
        Object[] objs = currentSteps.objs;
        try {
            for (int x = 0; x < len; ++x) {
                ((Steppable)objs[x]).step(state);
                objs[x] = null;
            }
        }
        finally {
            currentSteps.numObjs = 0;
            Object object2 = this.lock;
            synchronized (object2) {
                ++this.steps;
            }
            this.inStep = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnce(Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(this.time + 1.0, 0), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnceIn(double delta, Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(this.time + delta, 0), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnce(Steppable event, int ordering) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(this.time + 1.0, ordering), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnceIn(double delta, Steppable event, int ordering) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(this.time + delta, ordering), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnce(double time, Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(time, 0), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleOnce(double time, int ordering, Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(new Key(time, ordering), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleOnce(Key key, Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this._scheduleOnce(key, event);
        }
    }

    boolean _scheduleOnce(Key key, Steppable event) {
        double time = 0.0;
        double t = key.time;
        time = this.time;
        if (t == time && t != Double.POSITIVE_INFINITY) {
            t = key.time = Double.longBitsToDouble(Double.doubleToRawLongBits(t) + 1L);
        }
        if (this.sealed | t >= Double.POSITIVE_INFINITY) {
            return false;
        }
        if (t < 0.0) {
            throw new IllegalArgumentException("For the Steppable...\n\n" + event + "\n\n...the time provided (" + t + ") is < EPOCH (" + 0.0 + ")");
        }
        if (t != t) {
            throw new IllegalArgumentException("For the Steppable...\n\n" + event + "\n\n...the time provided (" + t + ") is NaN");
        }
        if (t < time) {
            throw new IllegalArgumentException("For the Steppable...\n\n" + event + "\n\n...the time provided (" + t + ") is less than the current time (" + time + ")");
        }
        if (event == null) {
            throw new IllegalArgumentException("The provided Steppable is null");
        }
        this.queue.add(event, key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stoppable scheduleRepeating(Steppable event) {
        Object object = this.lock;
        synchronized (object) {
            return this.scheduleRepeating(this.time + 1.0, 0, event, 1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stoppable scheduleRepeating(Steppable event, double interval) {
        Object object = this.lock;
        synchronized (object) {
            return this.scheduleRepeating(this.time + interval, 0, event, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stoppable scheduleRepeating(Steppable event, int ordering, double interval) {
        Object object = this.lock;
        synchronized (object) {
            return this.scheduleRepeating(this.time + interval, ordering, event, interval);
        }
    }

    public Stoppable scheduleRepeating(double time, Steppable event) {
        return this.scheduleRepeating(time, 0, event, 1.0);
    }

    public Stoppable scheduleRepeating(double time, Steppable event, double interval) {
        return this.scheduleRepeating(time, 0, event, interval);
    }

    public Stoppable scheduleRepeating(double time, int ordering, Steppable event) {
        return this.scheduleRepeating(time, ordering, event, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stoppable scheduleRepeating(double time, int ordering, Steppable event, double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("The steppable " + event + " was scheduled repeating with an impossible interval (" + interval + ")");
        }
        Key k = new Key(time, ordering);
        Repeat r = new Repeat(event, interval, k);
        Object object = this.lock;
        synchronized (object) {
            if (this._scheduleOnce(k, r)) {
                return r;
            }
            return null;
        }
    }

    protected static class Key
    implements Comparable,
    Serializable {
        double time;
        int ordering;

        public int getOrdering() {
            return this.ordering;
        }

        public double getTime() {
            return this.time;
        }

        public Key(double time, int ordering) {
            this.time = time;
            this.ordering = ordering;
        }

        public boolean equals(Object obj) {
            Key o = (Key)obj;
            return o.time == this.time && o.ordering == this.ordering;
        }

        public int hashCode() {
            int y = this.ordering;
            y += ~(y << 15);
            y ^= y >>> 10;
            y += y << 3;
            y ^= y >>> 6;
            y += ~(y << 11);
            y ^= y >>> 16;
            long key = Double.doubleToRawLongBits(this.time);
            key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 22;
            key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 8;
            key += key << 3;
            key ^= key >>> 15;
            key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 31;
            return (int)(key ^ key >> 32) ^ y;
        }

        public int compareTo(Object obj) {
            Key o = (Key)obj;
            double time = this.time;
            double time2 = o.time;
            if (time == time2) {
                int ordering = this.ordering;
                int ordering2 = o.ordering;
                if (ordering == ordering2) {
                    return 0;
                }
                if (ordering < ordering2) {
                    return -1;
                }
                return 1;
            }
            if (time < time2) {
                return -1;
            }
            return 1;
        }
    }
}

