/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.Grid2D;
import sim.util.IntBag;

public abstract class AbstractGrid2D
implements Grid2D {
    protected int width;
    protected int height;

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int tx(int x) {
        int width = this.width;
        if (x >= 0 && x < width) {
            return x;
        }
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    public final int ty(int y) {
        int height = this.height;
        if (y >= 0 && y < height) {
            return y;
        }
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    public final int stx(int x) {
        if (x >= 0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    public final int sty(int y) {
        if (y >= 0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    final int stx(int x, int width) {
        if (x >= 0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    final int sty(int y, int height) {
        if (y >= 0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public final int ulx(int x, int y) {
        return x - 1;
    }

    public final int uly(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    public final int urx(int x, int y) {
        return x + 1;
    }

    public final int ury(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    public final int dlx(int x, int y) {
        return x - 1;
    }

    public final int dly(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    public final int drx(int x, int y) {
        return x + 1;
    }

    public final int dry(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    public final int upx(int x, int y) {
        return x;
    }

    public final int upy(int x, int y) {
        return y - 1;
    }

    public final int downx(int x, int y) {
        return x;
    }

    public final int downy(int x, int y) {
        return y + 1;
    }

    public boolean trb(int x, int y) {
        return (x + y & 1) == 1;
    }

    public boolean trt(int x, int y) {
        return (x + y & 1) == 0;
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int xmin = x - dist;
            int xmax = x + dist;
            int ymin = y - dist;
            int ymax = y + dist;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                int x_0 = this.stx(x0, width);
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    int y_0 = this.sty(y0, height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                }
            }
        } else {
            int xmin = x - dist >= 0 ? x - dist : 0;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            int ymin = y - dist >= 0 ? y - dist : 0;
            int ymax = y + dist <= height - 1 ? y + dist : height - 1;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    xPos.add(x0);
                    yPos.add(y0);
                }
            }
        }
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int xmin;
            int xmax = x + dist;
            for (int x0 = xmin = x - dist; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = this.stx(x0, width);
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)); y0 <= ymax; ++y0) {
                    int y_0 = this.sty(y0, height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                }
            }
        } else {
            int xmin;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            for (int x0 = xmin = x - dist >= 0 ? x - dist : 0; x0 <= xmax; ++x0) {
                int ymin;
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) <= height - 1 ? y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : height - 1;
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) >= 0 ? y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : 0; y0 <= ymax; ++y0) {
                    xPos.add(x0);
                    yPos.add(y0);
                }
            }
        }
    }

    double dxForRadius(double dy, double radius) {
        return Math.sqrt(radius * radius - dy * dy);
    }

    double dxForAngle(double dy, double xa, double ya) {
        if (ya == 0.0 && dy == 0.0) {
            return xa > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (dy >= 0.0 && ya >= 0.0 || dy <= 0.0 && ya <= 0.0) {
            return xa * dy / ya;
        }
        return Double.NaN;
    }

    boolean nextTo(double a, double b, double c, double d) {
        return !(!(a <= b) || c >= a && c <= b || d >= a && d <= b);
    }

    int pushLeft(double x, double y, double slope, double radiusSq) {
        System.err.println("<---- " + x + " " + y + " " + slope);
        double xa = x;
        double ya = y;
        int xi = (int)xa;
        int yi = (int)ya;
        while ((slope >= 0.0 && (double)xi * slope >= (double)yi || slope < 0.0 && (double)xi * slope < (double)(yi + 1)) && (double)(xi * xi) + (double)xi * slope * ((double)xi * slope) < radiusSq) {
            --xi;
        }
        return xi;
    }

    int pushRight(double x, double y, double slope, double radiusSq) {
        System.err.println("----> " + x + " " + y + " " + slope);
        double xa = x;
        double ya = y;
        int xi = (int)xa;
        int yi = (int)ya;
        while ((slope <= 0.0 && (double)(xi + 1) * slope >= (double)yi || slope > 0.0 && (double)(xi + 1) * slope < (double)(yi + 1)) && (double)((xi + 1) * (xi + 1)) * ((double)(xi + 1) * slope) * ((double)(xi + 1) * slope) < radiusSq) {
            ++xi;
        }
        return xi;
    }

    boolean scan(int x, int y, int dy, double radius, double xa, double ya, double xb, double yb, boolean crossesZero, boolean crossesPi, boolean toroidal, IntBag xPos, IntBag yPos) {
        int i;
        if ((double)dy > radius || (double)dy < -radius) {
            return false;
        }
        double r = this.dxForRadius(dy, radius);
        double l = -r;
        double s = this.dxForAngle(dy, xa, ya);
        double e = this.dxForAngle(dy, xb, yb);
        int min = 0;
        int max = 0;
        System.err.println("dy=" + dy + " radius=" + radius + " zero=" + crossesZero + " Pi=" + crossesPi);
        System.err.println("xa " + xa + " ya " + ya + " xb " + xb + " yb " + yb);
        System.err.println("r " + r + " l " + l + " s " + s + " e " + e);
        if (s == Double.POSITIVE_INFINITY && e == Double.POSITIVE_INFINITY || s == Double.NEGATIVE_INFINITY && e == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (dy >= 0) {
            int i2;
            if (l != l) {
                return false;
            }
            if (s == e) {
                System.err.println("S==E");
                if (s * s + (double)(dy * dy) > radius * radius) {
                    return false;
                }
                min = this.pushLeft(s, dy, ya / xa, radius * radius);
                max = this.pushRight(s, dy, ya / xa, radius * radius);
            } else if (l <= s && s <= e && e <= r) {
                System.err.println("LSER");
                min = (int)Math.floor(l);
                max = (int)Math.ceil(s);
                if (toroidal) {
                    for (i2 = min; i2 <= max; ++i2) {
                        xPos.add(this.stx(x + i2));
                        yPos.add(this.sty(y + dy));
                    }
                } else {
                    for (i2 = min; i2 <= max; ++i2) {
                        xPos.add(x + i2);
                        yPos.add(y + dy);
                    }
                }
                min = (int)Math.floor(e);
                max = (int)Math.ceil(r);
            } else if (e <= l && l <= r && r <= s || l <= r && r <= s && s <= e) {
                System.err.println("LR");
                min = (int)Math.floor(l);
                max = (int)Math.ceil(r);
            } else if (l <= e && e <= s && s <= r) {
                System.err.println("ES");
                min = (int)Math.floor(e);
                max = (int)Math.ceil(s);
            } else if (this.nextTo(e, r, l, s)) {
                System.err.println("ER");
                min = (int)Math.floor(e);
                max = (int)Math.ceil(r);
            } else if (this.nextTo(l, s, e, r)) {
                System.err.println("LS");
                min = (int)Math.floor(l);
                max = (int)Math.ceil(s);
            } else {
                return false;
            }
            System.err.println("MIN " + min + " MAX " + max);
            if (toroidal) {
                for (i2 = min; i2 <= max; ++i2) {
                    xPos.add(this.stx(x + i2));
                    yPos.add(this.sty(y + dy));
                }
            } else {
                for (i2 = min; i2 <= max; ++i2) {
                    xPos.add(x + i2);
                    yPos.add(y + dy);
                }
            }
            return true;
        }
        if (l != l) {
            return false;
        }
        if (l <= e && e <= s && s <= r) {
            min = (int)Math.round(l);
            max = (int)Math.round(e);
            if (toroidal) {
                for (i = min; i <= max; ++i) {
                    xPos.add(this.stx(x + i));
                    yPos.add(this.sty(y + dy));
                }
            } else {
                for (i = min; i <= max; ++i) {
                    xPos.add(x + i);
                    yPos.add(y + dy);
                }
            }
            min = (int)Math.round(s);
            max = (int)Math.round(r);
        } else if (this.nextTo(l, r, e, s) && s <= e) {
            min = (int)Math.round(l);
            max = (int)Math.round(r);
        } else if (this.nextTo(s, e, l, r)) {
            min = (int)Math.round(s);
            max = (int)Math.round(e);
        } else if (this.nextTo(l, e, r, s)) {
            min = (int)Math.round(l);
            max = (int)Math.round(e);
        } else if (this.nextTo(s, r, l, e)) {
            min = (int)Math.round(s);
            max = (int)Math.round(r);
        } else {
            return false;
        }
        if (toroidal) {
            for (i = min; i <= max; ++i) {
                xPos.add(this.stx(x + i));
                yPos.add(this.sty(y));
            }
        } else {
            for (i = min; i <= max; ++i) {
                xPos.add(x + i);
                yPos.add(y);
            }
        }
        return true;
    }

    public void getNeighborsWithinArc(int x, int y, double radius, double startAngle, double endAngle, IntBag xPos, IntBag yPos) {
        this.getNeighborsWithinArc(x, y, radius, startAngle, endAngle, false, xPos, yPos);
    }

    public void getNeighborsWithinArc(int x, int y, double radius, double startAngle, double endAngle, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (radius < 0.0) {
            throw new RuntimeException("Radius must be positive");
        }
        xPos.clear();
        yPos.clear();
        if (startAngle < 0.0) {
            startAngle += Math.PI * 2;
        }
        if (startAngle < 0.0) {
            startAngle = startAngle % Math.PI * 2.0 + Math.PI * 2;
        }
        if (startAngle >= Math.PI * 2) {
            startAngle = startAngle % Math.PI * 2.0;
        }
        if (endAngle < 0.0) {
            endAngle += Math.PI * 2;
        }
        if (endAngle < 0.0) {
            endAngle = endAngle % Math.PI * 2.0 + Math.PI * 2;
        }
        if (endAngle >= Math.PI * 2) {
            endAngle = endAngle % Math.PI * 2.0;
        }
        double xa = Math.cos(startAngle);
        double ya = Math.sin(startAngle);
        double xb = Math.cos(endAngle);
        double yb = Math.sin(endAngle);
        boolean crossesZero = false;
        boolean crossesPi = false;
        if (startAngle > endAngle || startAngle == 0.0 || endAngle == 0.0) {
            crossesZero = true;
        } else if (startAngle <= Math.PI && endAngle >= Math.PI) {
            crossesPi = true;
        }
        int dy = 0;
        while (this.scan(x, y, dy, radius, xa, ya, xb, yb, crossesZero, crossesPi, toroidal, xPos, yPos)) {
            ++dy;
        }
        dy = -1;
        while (this.scan(x, y, dy, radius, xa, ya, xb, yb, crossesZero, crossesPi, toroidal, xPos, yPos)) {
            --dy;
        }
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsHexagonalDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal && width % 2 == 1) {
            throw new RuntimeException("Runtime exception in getNeighborsHexagonalDistance: toroidal hexagonal environment should have an even width");
        }
        if (toroidal) {
            int y0;
            int temp_ymin;
            int i;
            int ymin = y - dist;
            int ymax = y + dist;
            int y02 = ymin;
            while (y02 <= ymax) {
                xPos.add(this.stx(x, width));
                yPos.add(this.sty(y02, height));
                y02 = this.downy(x, y02);
            }
            int x0 = x;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.stx(x0, width));
                    yPos.add(this.sty(y0, height));
                    y0 = this.downy(x0, y0);
                }
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.stx(x0, width));
                    yPos.add(this.sty(y0, height));
                    y0 = this.downy(x0, y0);
                }
            }
        } else {
            int y0;
            int temp_ymin;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height) {
                throw new RuntimeException("Runtime exception in method getNeighborsHexagonalDistance: invalid initial position");
            }
            int ylBound = y - dist < 0 ? 0 : y - dist;
            int yuBound = y + dist < height ? y + dist : height - 1;
            int y03 = ylBound;
            while (y03 <= yuBound) {
                xPos.add(x);
                yPos.add(y03);
                y03 = this.downy(x, y03);
            }
            int x0 = x;
            int ymin = y - dist;
            int ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                ylBound = ymin >= 0 ? ymin : 0;
                int n = yuBound = ymax < height ? ymax : height - 1;
                if (x0 < 0) continue;
                y0 = ylBound;
                while (y0 <= yuBound) {
                    if (y0 >= 0) {
                        xPos.add(x0);
                        yPos.add(y0);
                    }
                    y0 = this.downy(x0, y0);
                }
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                ylBound = ymin >= 0 ? ymin : 0;
                int n = yuBound = ymax < height ? ymax : height - 1;
                if (x0 >= width) continue;
                y0 = ylBound;
                while (y0 <= yuBound) {
                    if (y0 >= 0) {
                        xPos.add(x0);
                        yPos.add(y0);
                    }
                    y0 = this.downy(x0, y0);
                }
            }
        }
    }
}

