/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.Grid3D;
import sim.util.IntBag;

public abstract class AbstractGrid3D
implements Grid3D {
    protected int width;
    protected int height;
    protected int length;

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getLength() {
        return this.length;
    }

    public final int tx(int x) {
        int width = this.width;
        if (x >= 0 && x < width) {
            return x;
        }
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    public final int ty(int y) {
        int height = this.height;
        if (y >= 0 && y < height) {
            return y;
        }
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    public final int tz(int z) {
        int length = this.length;
        if (z >= 0 && z < length) {
            return z;
        }
        if ((z %= length) < 0) {
            z += this.height;
        }
        return z;
    }

    public final int stx(int x) {
        if (x >= 0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    public final int sty(int y) {
        if (y >= 0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    public final int stz(int z) {
        if (z >= 0) {
            if (z < this.length) {
                return z;
            }
            return z - this.length;
        }
        return z + this.length;
    }

    final int stx(int x, int width) {
        if (x >= 0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    final int sty(int y, int height) {
        if (y >= 0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public final int stz(int z, int length) {
        if (z >= 0) {
            if (z < length) {
                return z;
            }
            return z - length;
        }
        return z + length;
    }

    public void getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null || zPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        zPos.clear();
        int height = this.height;
        int width = this.width;
        int length = this.length;
        if (toroidal) {
            int xmin = x - dist;
            int xmax = x + dist;
            int ymin = y - dist;
            int ymax = y + dist;
            int zmin = z - dist;
            int zmax = z + dist;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                int x_0 = this.stx(x0, width);
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    int y_0 = this.sty(y0, height);
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        int z_0 = this.stz(z0, length);
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
        } else {
            int xmin = x - dist >= 0 ? x - dist : 0;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            int ymin = y - dist >= 0 ? y - dist : 0;
            int ymax = y + dist <= height - 1 ? y + dist : height - 1;
            int zmin = z - dist >= 0 ? z - dist : 0;
            int zmax = z + dist <= length - 1 ? z + dist : length - 1;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        if (x0 == x && y0 == y && z0 == z) continue;
                        xPos.add(x0);
                        yPos.add(y0);
                        zPos.add(z0);
                    }
                }
            }
        }
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null || zPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        zPos.clear();
        int height = this.height;
        int width = this.width;
        int length = this.length;
        if (toroidal) {
            int xmin;
            int xmax = x + dist;
            for (int x0 = xmin = x - dist; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = this.stx(x0, width);
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)); y0 <= ymax; ++y0) {
                    int zmin;
                    int y_0 = this.sty(y0, height);
                    int zmax = z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0));
                    for (int z0 = zmin = z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)); z0 <= zmax; ++z0) {
                        int z_0 = this.stz(z0, length);
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
        } else {
            int xmin;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            for (int x0 = xmin = x - dist >= 0 ? x - dist : 0; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = x0;
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) <= height - 1 ? y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : height - 1;
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) >= 0 ? y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : 0; y0 <= ymax; ++y0) {
                    int y_0 = y0;
                    int zmin = z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) >= 0 ? z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) : 0;
                    int zmax = z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) <= length - 1 ? z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) : length - 1;
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        int z_0 = z0;
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
        }
    }
}

