/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import java.util.Collection;
import sim.field.grid.AbstractGrid2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.IntBag;

public class DenseGrid2D
extends AbstractGrid2D {
    public boolean removeEmptyBags = true;
    public boolean replaceLargeBags = true;
    public static final int INITIAL_BAG_SIZE = 16;
    public static final int MIN_BAG_SIZE = 32;
    public static final int LARGE_BAG_RATIO = 4;
    public static final int REPLACEMENT_BAG_RATIO = 2;
    public Bag[][] field;

    public DenseGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new Bag[width][height];
    }

    public Bag getObjectsAtLocation(int x, int y) {
        return this.field[x][y];
    }

    public Bag getObjectsAtLocation(Int2D location) {
        return this.getObjectsAtLocation(location.x, location.y);
    }

    public Bag removeObjectsAtLocation(int x, int y) {
        Bag b = this.field[x][y];
        this.field[x][y] = null;
        return b;
    }

    public Bag removeObjectsAtLocation(Int2D location) {
        return this.removeObjectsAtLocation(location.x, location.y);
    }

    public boolean removeObjectAtLocation(Object obj, int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return false;
        }
        boolean result = b.remove(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectAtLocation(Object obj, Int2D location) {
        return this.removeObjectAtLocation(obj, location.x, location.y);
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return false;
        }
        boolean result = b.removeMultiply(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, Int2D location) {
        return this.removeObjectMultiplyAtLocation(obj, location.x, location.y);
    }

    public boolean moveObject(Object obj, int fromX, int fromY, int toX, int toY) {
        boolean result = this.removeObjectAtLocation(obj, fromX, fromY);
        this.addObjectToLocation(obj, toX, toY);
        return result;
    }

    public boolean moveObject(Object obj, Int2D from, Int2D to) {
        return this.moveObject(obj, from.x, from.y, to.x, to.y);
    }

    public void moveObjects(int fromX, int fromY, int toX, int toY) {
        this.addObjectsToLocation(this.removeObjectsAtLocation(fromX, fromY), toX, toY);
    }

    public void moveObjects(Int2D from, Int2D to) {
        this.moveObjects(from.x, from.y, to.x, to.y);
    }

    public int numObjectsAtLocation(int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return 0;
        }
        return b.numObjs;
    }

    public int numObjectsAtLocation(Int2D location) {
        return this.numObjectsAtLocation(location.x, location.y);
    }

    void buildBag(Bag[] fieldx, int y) {
        fieldx[y] = new Bag(16);
    }

    public void addObjectToLocation(Object obj, int x, int y) {
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].add(obj);
    }

    public void addObjectToLocation(Object obj, Int2D location) {
        this.addObjectToLocation(obj, location.x, location.y);
    }

    public void addObjectsToLocation(Bag objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(objs);
    }

    public void addObjectsToLocation(Bag objs, Int2D location) {
        this.addObjectsToLocation(objs, location.x, location.y);
    }

    public void addObjectsToLocation(Object[] objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(0, objs);
    }

    public void addObjectsToLocation(Object[] objs, Int2D location) {
        this.addObjectsToLocation(objs, location.x, location.y);
    }

    public void addObjectsToLocation(Collection objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(objs);
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Bag[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] != null) {
                    bag.addAll(fieldx[y]);
                }
                fieldx[y] = null;
            }
        }
        return bag;
    }

    public final Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsMaxDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.addAll(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.addAll(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHexagonalDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.addAll(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }
}

