/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.util.Bag;
import sim.util.IntBag;

public class ObjectGrid2D
extends AbstractGrid2D {
    public Object[][] field;

    public ObjectGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new Object[width][height];
    }

    public ObjectGrid2D(int width, int height, Object initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public ObjectGrid2D(ObjectGrid2D values) {
        this.setTo(values);
    }

    public final void set(int x, int y, Object val) {
        this.field[x][y] = val;
    }

    public final Object get(int x, int y) {
        return this.field[x][y];
    }

    public final ObjectGrid2D setTo(Object thisObj) {
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = thisObj;
            }
        }
        return this;
    }

    public final Object[] toArray() {
        Object[][] field = this.field;
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        Object[] vals = new Object[width * height];
        int i = 0;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                vals[i++] = fieldx[y];
            }
        }
        return vals;
    }

    public final Bag elements() {
        Bag bag = new Bag();
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] == null) continue;
                bag.add(fieldx[y]);
            }
        }
        return bag;
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] != null) {
                    bag.add(fieldx[y]);
                }
                fieldx[y] = null;
            }
        }
        return bag;
    }

    public final ObjectGrid2D setTo(ObjectGrid2D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            this.field = new Object[width][];
            Object[][] field = this.field;
            Object[][] ofield = values.field;
            for (int x = 0; x < width; ++x) {
                field[x] = (Object[])ofield[x].clone();
            }
        } else {
            Object[][] field = this.field;
            Object[][] ofield = values.field;
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(ofield[x], 0, field[x], 0, this.height);
            }
        }
        return this;
    }

    public final Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsMaxDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHexagonalDistance(x, y, dist, toroidal, xPos, yPos);
        if (result != null) {
            result.clear();
            result.resize(xPos.size());
        } else {
            result = new Bag(xPos.size());
        }
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }
}

