/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network;

import java.io.Serializable;
import sim.field.network.Network;
import sim.util.Valuable;

public class Edge
implements Serializable,
Comparable {
    Network owner;
    Object from;
    Object to;
    public Object info;
    int indexFrom;
    int indexTo;

    public Object getFrom() {
        return this.from;
    }

    public Object getTo() {
        return this.to;
    }

    public boolean getDirected() {
        Network o = this.owner;
        if (o == null) {
            return true;
        }
        return o.isDirected();
    }

    public Object from() {
        return this.from;
    }

    public Object to() {
        return this.to;
    }

    public Network owner() {
        return this.owner;
    }

    public int indexFrom() {
        return this.indexFrom;
    }

    public int indexTo() {
        return this.indexTo;
    }

    public Edge(Edge e) {
        this.setTo(e.from, e.to, e.info, e.indexFrom, e.indexTo);
    }

    public Edge(Object from, Object to, Object info) {
        this.setTo(from, to, info, -1, -1);
    }

    void setTo(Object from, Object to, Object info, int indexFrom, int indexTo) {
        this.from = from;
        this.to = to;
        this.info = info;
        this.indexFrom = indexFrom;
        this.indexFrom = indexTo;
    }

    public double getWeight() {
        if (this.info instanceof Number) {
            return ((Number)this.info).doubleValue();
        }
        if (this.info instanceof Valuable) {
            return ((Valuable)this.info).doubleValue();
        }
        return 1.0;
    }

    public Object getOtherNode(Object node) {
        if (node.equals(this.from)) {
            return this.to;
        }
        return this.from;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object val) {
        this.info = val;
    }

    public String toString() {
        if (this.owner == null) {
            return "Unowned Edge[" + this.from + "->" + this.to + ": " + this.info + "]";
        }
        if (this.owner.isDirected()) {
            return "Edge[" + this.from + "->" + this.to + ": " + this.info + "]";
        }
        return "Edge[" + this.from + "<->" + this.to + ": " + this.info + "]";
    }

    public int compareTo(Object obj) {
        if (this.info == null || obj == null || !(obj instanceof Edge)) {
            return 0;
        }
        Edge other = (Edge)obj;
        if (other.info instanceof Long && this.info instanceof Long) {
            long l2;
            long l = (Long)this.info;
            if (l == (l2 = ((Long)other.info).longValue())) {
                return 0;
            }
            return l < l2 ? -1 : 1;
        }
        if (this.info instanceof Number) {
            double d = ((Number)this.info).doubleValue();
            if (other.info instanceof Number) {
                double d2 = ((Number)other.info).doubleValue();
                if (d == d2) {
                    return 0;
                }
                return d < d2 ? -1 : 1;
            }
            if (other.info instanceof Valuable) {
                double d2 = ((Valuable)other.info).doubleValue();
                if (d == d2) {
                    return 0;
                }
                return d < d2 ? -1 : 1;
            }
            return 0;
        }
        if (this.info instanceof Valuable) {
            double d = ((Valuable)this.info).doubleValue();
            if (other.info instanceof Number) {
                double d2 = ((Number)other.info).doubleValue();
                if (d == d2) {
                    return 0;
                }
                return d < d2 ? -1 : 1;
            }
            if (other.info instanceof Valuable) {
                double d2 = ((Valuable)other.info).doubleValue();
                if (d == d2) {
                    return 0;
                }
                return d < d2 ? -1 : 1;
            }
            return 0;
        }
        return 0;
    }
}

