/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.ObjectGridPortrayal2D;
import sim.util.Valuable;
import sim.util.gui.ColorMap;

public class FastObjectGridPortrayal2D
extends ObjectGridPortrayal2D {
    FastValueGridPortrayal2D valueGridPortrayal;
    DoubleGrid2D grid;

    public FastObjectGridPortrayal2D(boolean immutableField) {
        this.valueGridPortrayal = new FastValueGridPortrayal2D("", this.immutableField);
        this.setImmutableField(immutableField);
    }

    public FastObjectGridPortrayal2D() {
        this.valueGridPortrayal = new FastValueGridPortrayal2D("", this.immutableField);
    }

    public void setImmutableField(boolean immutableField) {
        super.setImmutableField(immutableField);
        this.valueGridPortrayal.setImmutableField(immutableField);
    }

    public void setField(Object field) {
        super.setField(field);
        ObjectGrid2D og = (ObjectGrid2D)field;
        this.grid = new DoubleGrid2D(og.getWidth(), og.getHeight());
        this.valueGridPortrayal.setField(this.grid);
    }

    public double doubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Valuable) {
            return ((Valuable)obj).doubleValue();
        }
        return 1.0;
    }

    public void reset() {
        this.valueGridPortrayal.reset();
    }

    public void setDirtyField(boolean val) {
        this.valueGridPortrayal.setDirtyField(val);
    }

    public boolean isDirtyField() {
        return this.valueGridPortrayal.isDirtyField();
    }

    public ColorMap getMap() {
        return this.valueGridPortrayal.getMap();
    }

    public void setMap(ColorMap m) {
        this.valueGridPortrayal.setMap(m);
    }

    public int getBuffering() {
        return this.valueGridPortrayal.getBuffering();
    }

    public void setBuffering(int val) {
        this.valueGridPortrayal.setBuffering(val);
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.field == null) {
            return;
        }
        ObjectGrid2D ogrid = (ObjectGrid2D)this.field;
        int maxX = ogrid.getWidth();
        int maxY = ogrid.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        for (int x = startx; x < endx; ++x) {
            double[] gridx = this.grid.field[x];
            Object[] ogridx = ogrid.field[x];
            for (int y = starty; y < endy; ++y) {
                gridx[y] = this.doubleValue(ogridx[y]);
            }
        }
        this.valueGridPortrayal.draw(object, graphics, info);
    }
}

