/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import sim.field.grid.SparseGrid2D;
import sim.portrayal.inspector.StableLocation;
import sim.util.Int2D;

public class StableInt2D
implements StableLocation {
    public int x = 0;
    public int y = 0;
    public boolean exists;
    public SparseGrid2D field;
    public Object object;

    public String toString() {
        this.update();
        if (!this.exists) {
            return "Gone";
        }
        return "(" + this.x + ", " + this.y + ")";
    }

    public StableInt2D(SparseGrid2D field, Object object) {
        this.field = field;
        this.object = object;
    }

    void update() {
        Int2D pos = null;
        if (this.field != null) {
            pos = this.field.getObjectLocation(this.object);
        }
        if (pos == null) {
            this.exists = false;
        } else {
            this.x = pos.x;
            this.y = pos.y;
            this.exists = true;
        }
    }

    public int getX() {
        this.update();
        return this.x;
    }

    public int getY() {
        this.update();
        return this.y;
    }

    public boolean getExists() {
        this.update();
        return this.exists;
    }

    public void setX(int val) {
        if (this.field != null) {
            this.field.setObjectLocation(this.object, new Int2D(val, this.getY()));
        }
        this.x = val;
        this.exists = true;
    }

    public void setY(int val) {
        if (this.field != null) {
            this.field.setObjectLocation(this.object, new Int2D(this.getX(), val));
        }
        this.y = val;
        this.exists = true;
    }
}

