/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;

public class LabelledPortrayal2D
extends SimplePortrayal2D {
    public static final double DEFAULT_SCALE_X = 0.0;
    public static final double DEFAULT_SCALE_Y = 0.5;
    public static final double DEFAULT_OFFSET_X = 0.0;
    public static final double DEFAULT_OFFSET_Y = 10.0;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = -1;
    public double scalex;
    public double scaley;
    public double offsetx;
    public double offsety;
    public int align;
    public Font font;
    public Paint paint;
    public String label;
    public SimplePortrayal2D child;
    boolean showLabel = true;
    public boolean onlyLabelWhenSelected;
    Font scaledFont;
    int labelScaling = 0;
    public static final int NEVER_SCALE = 0;
    public static final int SCALE_WHEN_SMALLER = 1;
    public static final int ALWAYS_SCALE = 2;

    public void setOnlyLabelWhenSelected(boolean val) {
        this.onlyLabelWhenSelected = val;
    }

    public boolean getOnlyLabelWhenSelected() {
        return this.onlyLabelWhenSelected;
    }

    public boolean isLabelShowing() {
        return this.showLabel;
    }

    public void setLabelShowing(boolean val) {
        this.showLabel = val;
    }

    public int getLabelScaling() {
        return this.labelScaling;
    }

    public void setLabelScaling(int val) {
        if (val >= 0 && val <= 2) {
            this.labelScaling = val;
        }
    }

    public LabelledPortrayal2D(SimplePortrayal2D child, double offsetx, double offsety, double scalex, double scaley, Font font, int align, String label, Paint paint, boolean onlyLabelWhenSelected) {
        this.offsetx = offsetx;
        this.offsety = offsety;
        this.scalex = scalex;
        this.scaley = scaley;
        this.font = font;
        this.align = align;
        this.label = label;
        this.child = child;
        this.paint = paint;
        this.onlyLabelWhenSelected = onlyLabelWhenSelected;
    }

    public LabelledPortrayal2D(SimplePortrayal2D child, String label) {
        this(child, label, Color.blue, false);
    }

    public LabelledPortrayal2D(SimplePortrayal2D child, double scaley, String label, Paint paint, boolean onlyLabelWhenSelected) {
        this(child, 0.0, 10.0, 0.0, scaley, new Font("SansSerif", 0, 10), 1, label, paint, onlyLabelWhenSelected);
    }

    public LabelledPortrayal2D(SimplePortrayal2D child, String label, Paint paint, boolean onlyLabelWhenSelected) {
        this(child, 0.0, 10.0, 0.0, 0.5, new Font("SansSerif", 0, 10), 1, label, paint, onlyLabelWhenSelected);
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to LabelledPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        this.getChild(object).draw(object, graphics, info);
        if (this.showLabel && (info.selected || !this.onlyLabelWhenSelected)) {
            String s;
            float size;
            Font labelFont = this.font;
            Font scaledFont = this.scaledFont;
            float f = size = this.labelScaling == 2 || this.labelScaling == 1 && info.draw.width < 1.0 ? (float)(info.draw.width * (double)labelFont.getSize2D()) : labelFont.getSize2D();
            if (scaledFont == null || scaledFont.getSize2D() != size || scaledFont.getFamily() != labelFont.getFamily() || scaledFont.getStyle() != labelFont.getStyle()) {
                scaledFont = this.scaledFont = labelFont.deriveFont(size);
            }
            if ((s = this.getLabel(object, info)) != null && !s.equals("")) {
                int x = (int)(info.draw.x + this.scalex * info.draw.width + this.offsetx);
                int y = (int)(info.draw.y + this.scaley * info.draw.height + this.offsety);
                graphics.setPaint(this.paint);
                graphics.setFont(scaledFont);
                if (this.align == 0) {
                    x -= graphics.getFontMetrics().stringWidth(s) / 2;
                } else if (this.align == -1) {
                    x -= graphics.getFontMetrics().stringWidth(s);
                }
                graphics.drawString(s, x, y);
            }
        }
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        return this.getChild(object).hitObject(object, range);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    public String getLabel(Object object, DrawInfo2D info) {
        if (this.label == null) {
            return "" + object;
        }
        return this.label;
    }

    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }

    public boolean handleMouseEvent(GUIState guistate, Manipulating2D manipulating, LocationWrapper wrapper, MouseEvent event, DrawInfo2D fieldPortrayalDrawInfo, int type) {
        return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, fieldPortrayalDrawInfo, type);
    }
}

