/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;

public class ShapePortrayal2D
extends SimplePortrayal2D {
    static final Stroke defaultStroke = new BasicStroke();
    public Paint paint;
    public double scale;
    public Shape shape;
    public Stroke stroke;
    public boolean filled;
    AffineTransform transform = new AffineTransform();
    double[] xPoints = null;
    double[] yPoints = null;
    double[] scaledXPoints = null;
    double[] scaledYPoints = null;
    int[] translatedXPoints = null;
    int[] translatedYPoints = null;
    double scaling;
    double bufferedWidth;
    double bufferedHeight;
    Shape bufferedShape;

    Shape buildPolygon(double[] xpoints, double[] ypoints) {
        GeneralPath path = new GeneralPath();
        if (xpoints.length > 0) {
            path.moveTo((float)xpoints[0], (float)ypoints[0]);
        }
        for (int i = xpoints.length - 1; i >= 0; --i) {
            path.lineTo((float)xpoints[i], (float)ypoints[i]);
        }
        return path;
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints) {
        this(xpoints, ypoints, Color.gray, 1.0, true);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, Paint paint) {
        this(xpoints, ypoints, paint, 1.0, true);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, double scale) {
        this(xpoints, ypoints, Color.gray, scale, true);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, Paint paint, double scale) {
        this(xpoints, ypoints, paint, scale, true);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, boolean filled) {
        this(xpoints, ypoints, Color.gray, 1.0, filled);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, Paint paint, boolean filled) {
        this(xpoints, ypoints, paint, 1.0, filled);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, double scale, boolean filled) {
        this(xpoints, ypoints, Color.gray, scale, filled);
    }

    public ShapePortrayal2D(double[] xpoints, double[] ypoints, Paint paint, double scale, boolean filled) {
        this(null, paint, scale, filled);
        this.shape = this.buildPolygon(xpoints, ypoints);
        this.xPoints = xpoints;
        this.yPoints = ypoints;
        this.scaledXPoints = new double[xpoints.length];
        this.scaledYPoints = new double[ypoints.length];
        this.translatedXPoints = new int[xpoints.length];
        this.translatedYPoints = new int[ypoints.length];
    }

    public ShapePortrayal2D(Shape shape) {
        this(shape, Color.gray, 1.0, true);
    }

    public ShapePortrayal2D(Shape shape, Paint paint) {
        this(shape, paint, 1.0, true);
    }

    public ShapePortrayal2D(Shape shape, double scale) {
        this(shape, Color.gray, scale, true);
    }

    public ShapePortrayal2D(Shape shape, Paint paint, double scale) {
        this(shape, paint, scale, true);
    }

    public ShapePortrayal2D(Shape shape, boolean filled) {
        this(shape, Color.gray, 1.0, filled);
    }

    public ShapePortrayal2D(Shape shape, Paint paint, boolean filled) {
        this(shape, paint, 1.0, filled);
    }

    public ShapePortrayal2D(Shape shape, double scale, boolean filled) {
        this(shape, Color.gray, scale, filled);
    }

    public ShapePortrayal2D(Shape shape, Paint paint, double scale, boolean filled) {
        this.shape = shape;
        this.paint = paint;
        this.scale = scale;
        this.filled = filled;
        this.setStroke(null);
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        graphics.setPaint(this.paint);
        double width = info.draw.width * this.scale;
        double height = info.draw.height * this.scale;
        if (this.bufferedShape == null || width != this.bufferedWidth || height != this.bufferedHeight) {
            this.bufferedWidth = width;
            this.bufferedHeight = height;
            this.transform.setToScale(this.bufferedWidth, this.bufferedHeight);
            this.bufferedShape = this.transform.createTransformedShape(this.shape);
        }
        this.transform.setToTranslation(info.draw.x, info.draw.y);
        if (this.filled) {
            graphics.fill(this.transform.createTransformedShape(this.bufferedShape));
        } else {
            graphics.setStroke(this.stroke == null ? defaultStroke : this.stroke);
            graphics.draw(this.transform.createTransformedShape(this.bufferedShape));
        }
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        double width = range.draw.width * this.scale;
        double height = range.draw.height * this.scale;
        if (this.bufferedShape == null || width != this.bufferedWidth || height != this.bufferedHeight) {
            this.bufferedWidth = width;
            this.bufferedHeight = height;
            this.transform.setToScale(this.bufferedWidth, this.bufferedHeight);
            this.bufferedShape = this.transform.createTransformedShape(this.shape);
        }
        this.transform.setToTranslation(range.draw.x, range.draw.y);
        return new Area(this.transform.createTransformedShape(this.bufferedShape)).intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
    }
}

