/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.display.GUIState;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimpleInspector;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;
import sim.util.Int2D;
import sim.util.MutableDouble;

public class ValuePortrayal2D
extends RectanglePortrayal2D {
    double level;
    boolean isTransparent;

    public ValuePortrayal2D() {
    }

    public ValuePortrayal2D(ValueGridPortrayal2D parent) {
        super(null);
    }

    public void setParent(ValueGridPortrayal2D parent) {
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        ValueGridPortrayal2D parent = (ValueGridPortrayal2D)info.fieldPortrayal;
        double levelHere = ((MutableDouble)object).val;
        if (this.paint == null || this.level != levelHere) {
            this.level = levelHere;
            Color c = parent.getMap().getColor(levelHere);
            if (c.getAlpha() == 0) {
                this.isTransparent = true;
            } else {
                this.paint = c;
            }
        }
        if (!this.isTransparent) {
            super.draw(object, graphics, info);
        }
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        if (((ValueGridPortrayal2D)wrapper.getFieldPortrayal()).getField() instanceof DoubleGrid2D) {
            return new SimpleInspector(new DoubleFilter(wrapper), state, "Properties");
        }
        return new SimpleInspector(new IntFilter(wrapper), state, "Properties");
    }

    public String getStatus(LocationWrapper wrapper) {
        return this.getName(wrapper) + ": " + ((MutableDouble)wrapper.getObject()).val;
    }

    public String getName(LocationWrapper wrapper) {
        ValueGridPortrayal2D portrayal = (ValueGridPortrayal2D)wrapper.getFieldPortrayal();
        return portrayal.getValueName() + " at " + wrapper.getLocationName();
    }

    public static class IntFilter
    extends Filter {
        public IntFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public int getValue() {
            return ((IntGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y];
        }

        public void setValue(int val) {
            ((IntGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y] = (int)this.fieldPortrayal.newValue(this.x, this.y, val);
        }
    }

    public static class DoubleFilter
    extends Filter {
        public DoubleFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public double getValue() {
            return ((DoubleGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y];
        }

        public void setValue(double val) {
            ((DoubleGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y] = this.fieldPortrayal.newValue(this.x, this.y, val);
        }
    }

    public static abstract class Filter {
        int x;
        int y;
        ValueGridPortrayal2D fieldPortrayal;
        String name;

        public Filter(LocationWrapper wrapper) {
            this.fieldPortrayal = (ValueGridPortrayal2D)wrapper.getFieldPortrayal();
            Int2D loc = (Int2D)wrapper.getLocation();
            this.x = loc.x;
            this.y = loc.y;
            this.name = this.fieldPortrayal.getValueName() + " at " + wrapper.getLocationName();
        }

        public String toString() {
            return this.name;
        }
    }
}

