/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid;

import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import sim.field.grid.SparseGrid2D;
import sim.portrayal.Portrayal;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.grid.SparseGridPortrayal3D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.MutableDouble;

public class SparseGrid2DPortrayal3D
extends SparseGridPortrayal3D {
    public double zScale;

    public SparseGrid2DPortrayal3D(double zScale) {
        this.zScale = zScale;
    }

    public SparseGrid2DPortrayal3D() {
        this(1.0);
    }

    public void setField(Object field) {
        if (!(field instanceof SparseGrid2D)) {
            throw new RuntimeException("Invalid field for StackedSparse2DPortrayal3D: " + field);
        }
        super.setField(field);
    }

    public TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        globalTG.setCapability(13);
        globalTG.setCapability(14);
        if (this.field == null) {
            return globalTG;
        }
        Vector3d tmpV3D = new Vector3d();
        Transform3D tmpLocalT = new Transform3D();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        SparseGrid2D grid = (SparseGrid2D)this.field;
        Bag allobjs = grid.getAllObjects();
        for (int i = 0; i < allobjs.numObjs; ++i) {
            if (map.containsKey(allobjs.objs[i])) continue;
            Int2D location = grid.getObjectLocation(allobjs.objs[i]);
            Bag b = grid.getObjectsAtLocation(location);
            tmpV3D.x = location.x;
            tmpV3D.y = location.y;
            if (b == null) continue;
            for (int z = 0; z < b.numObjs; ++z) {
                map.put(b.objs[z], b.objs[z]);
                tmpV3D.z = (double)z * this.zScale;
                tmpLocalT.setTranslation(tmpV3D);
                BranchGroup localBG = this.wrapModelForNewObject(b.objs[z], tmpLocalT);
                globalTG.addChild((Node)localBG);
            }
        }
        return globalTG;
    }

    public void updateModel(TransformGroup globalTG) {
        SparseGrid2D grid = (SparseGrid2D)this.field;
        if (grid == null) {
            return;
        }
        Vector3d tmpV3D = new Vector3d();
        Bag b = grid.getAllObjects();
        Transform3D tmpLocalT = new Transform3D();
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        HashMap<Int2D, MutableDouble> stackCountByLocation = new HashMap<Int2D, MutableDouble>();
        for (int i = 0; i < b.numObjs; ++i) {
            hm.put(b.objs[i], b.objs[i]);
        }
        for (int t = globalTG.numChildren() - 1; t >= 0; --t) {
            BranchGroup localBG = (BranchGroup)globalTG.getChild(t);
            Object fieldObj = localBG.getUserData();
            if (hm.remove(fieldObj) != null) {
                TransformGroup localTG = (TransformGroup)localBG.getChild(0);
                Portrayal p = this.getPortrayalForObject(fieldObj);
                if (!(p instanceof SimplePortrayal3D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + fieldObj + " -- expecting a SimplePortrayal3D");
                }
                SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                p3d.setCurrentFieldPortrayal(this);
                TransformGroup localTG2 = p3d.getModel(fieldObj, localTG);
                Int2D location = grid.getObjectLocation(fieldObj);
                tmpV3D.x = location.x;
                tmpV3D.y = location.y;
                MutableDouble d = (MutableDouble)stackCountByLocation.get(location);
                if (d == null) {
                    d = new MutableDouble(0.0);
                    stackCountByLocation.put(location, d);
                } else {
                    d.val += 1.0;
                }
                tmpV3D.z = d.val * this.zScale;
                tmpLocalT.setTranslation(tmpV3D);
                localTG2.setTransform(tmpLocalT);
                if (localTG == localTG2) continue;
                localTG2.setCapability(18);
                localTG2.setCapability(17);
                BranchGroup newlocalBG = new BranchGroup();
                newlocalBG.setCapability(12);
                newlocalBG.setCapability(17);
                newlocalBG.setUserData(fieldObj);
                newlocalBG.addChild((Node)localTG2);
                globalTG.setChild((Node)newlocalBG, t);
                continue;
            }
            globalTG.removeChild(t);
        }
        if (!hm.isEmpty()) {
            Iterator newObjs = hm.values().iterator();
            while (newObjs.hasNext()) {
                Object fieldObj = newObjs.next();
                Int2D location = grid.getObjectLocation(fieldObj);
                tmpV3D.x = location.x;
                tmpV3D.y = location.y;
                MutableDouble d = (MutableDouble)stackCountByLocation.get(location);
                if (d == null) {
                    d = new MutableDouble(0.0);
                    stackCountByLocation.put(location, d);
                } else {
                    d.val += 1.0;
                }
                tmpV3D.z = d.val * this.zScale;
                tmpLocalT.setTranslation(tmpV3D);
                BranchGroup localBG = this.wrapModelForNewObject(fieldObj, tmpLocalT);
                globalTG.addChild((Node)localBG);
            }
            hm.clear();
        }
    }
}

