/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid.quad;

import com.sun.j3d.utils.picking.PickIntersection;
import sim.field.grid.Grid2D;
import sim.portrayal3d.grid.quad.QuadPortrayal;
import sim.portrayal3d.grid.quad.ValueGridCellInfo;
import sim.util.Int2D;
import sim.util.gui.ColorMap;

public class MeshPortrayal
extends QuadPortrayal {
    float[] tmpCoords = new float[12];
    float[] tmpColor = new float[4];
    static final int[] dx = new int[]{0, -1, -1, 0};
    static final int[] dy = new int[]{0, 0, -1, -1};

    public MeshPortrayal(ColorMap colorDispenser) {
        this(colorDispenser, 0.0);
    }

    public MeshPortrayal(ColorMap colorDispenser, double zScale) {
        super(colorDispenser, zScale);
    }

    public void setData(ValueGridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex, int gridWidth, int gridHeight) {
        --gridWidth;
        --gridHeight;
        int x = gridCell.x;
        int y = gridCell.y;
        float value = (float)gridCell.value();
        this.colorDispenser.getColor(value).getColorComponents(this.tmpColor);
        value = (float)((double)value * this.zScale);
        for (int i = 0; i < 4; ++i) {
            int cellx = x + dx[i];
            int celly = y + dy[i];
            if (cellx < 0 || celly < 0 || cellx >= gridWidth || celly >= gridHeight) continue;
            int iQuadIndex = cellx * gridHeight + celly;
            int offset = iQuadIndex * 12 + i * 3;
            coordinates[offset + 0] = x;
            coordinates[offset + 1] = y;
            coordinates[offset + 2] = value + 0.1f;
            System.arraycopy(this.tmpColor, 0, colors, (iQuadIndex * 4 + i) * 3, 3);
        }
    }

    public Int2D getCellForIntersection(PickIntersection pi, Grid2D field) {
        int[] indices = pi.getPrimitiveVertexIndices();
        int closenessOffset = pi.getClosestVertexIndex();
        int xExtraOffset = (closenessOffset = indices[closenessOffset] % 4) == 3 || closenessOffset == 0 ? 0 : 1;
        int yExtraOffset = closenessOffset == 3 || closenessOffset == 2 ? 1 : 0;
        int height = field.getHeight();
        int x = indices[0] / 4 / (height - 1) + xExtraOffset;
        int y = indices[0] / 4 % (height - 1) + yExtraOffset;
        return new Int2D(x, y);
    }
}

