/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.inspector;

import sim.field.SparseField;
import sim.field.continuous.Continuous2D;
import sim.field.continuous.Continuous3D;
import sim.portrayal.inspector.StableLocation;
import sim.util.Double2D;
import sim.util.Double3D;

public class StableDouble3D
implements StableLocation {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public boolean exists = false;
    public SparseField field;
    public Object object;

    public String toString() {
        this.update();
        if (!this.exists) {
            return "Gone";
        }
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public StableDouble3D(Continuous2D field, Object object) {
        this.field = field;
        this.object = object;
    }

    public StableDouble3D(Continuous3D field, Object object) {
        this.field = field;
        this.object = object;
    }

    void update() {
        Double3D pos = null;
        if (this.field == null) {
            return;
        }
        pos = this.field instanceof Continuous2D ? new Double3D(((Continuous2D)this.field).getObjectLocation(this.object)) : ((Continuous3D)this.field).getObjectLocation(this.object);
        if (pos == null) {
            this.exists = false;
        } else {
            this.x = pos.x;
            this.y = pos.y;
            this.z = pos.z;
            this.exists = true;
        }
    }

    public double getX() {
        this.update();
        return this.x;
    }

    public double getY() {
        this.update();
        return this.y;
    }

    public double getZ() {
        this.update();
        return this.z;
    }

    public boolean getExists() {
        this.update();
        return this.exists;
    }

    public void setX(double val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof Continuous2D) {
            ((Continuous2D)this.field).setObjectLocation(this.object, new Double2D(val, this.getY()));
            this.z = 0.0;
        } else {
            ((Continuous3D)this.field).setObjectLocation(this.object, new Double3D(val, this.getY(), this.getZ()));
        }
        this.x = val;
        this.exists = true;
    }

    public void setY(double val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof Continuous2D) {
            ((Continuous2D)this.field).setObjectLocation(this.object, new Double2D(this.getX(), val));
            this.z = 0.0;
        } else {
            ((Continuous3D)this.field).setObjectLocation(this.object, new Double3D(this.getX(), val, this.getZ()));
        }
        this.y = val;
        this.exists = true;
    }

    public void setZ(double val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof Continuous2D) {
            this.z = 0.0;
            return;
        }
        ((Continuous3D)this.field).setObjectLocation(this.object, new Double3D(this.getX(), this.getY(), val));
        this.z = val;
        this.exists = true;
    }
}

