/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import sim.portrayal3d.network.PrimitiveEdgePortrayal3D;
import sim.portrayal3d.simple.Arrow;
import sim.portrayal3d.simple.PrimitivePortrayal3D;
import sim.util.Double3D;

public class ArrowEdgePortrayal3D
extends PrimitiveEdgePortrayal3D {
    static Double3D dummyFrom = new Double3D(0.0, -1.0, 0.0);
    static Double3D dummyTo = new Double3D(0.0, 1.0, 0.0);

    public ArrowEdgePortrayal3D() {
        this(null, Color.white, null, 0.5);
    }

    public ArrowEdgePortrayal3D(double radius) {
        this(null, Color.white, null, radius);
    }

    public ArrowEdgePortrayal3D(double radius, Appearance ap) {
        this(ap, Color.white, null, radius);
    }

    public ArrowEdgePortrayal3D(Color labelColor) {
        this(null, labelColor, null, 0.5);
    }

    public ArrowEdgePortrayal3D(Appearance appearance, Color labelColor) {
        this(appearance, labelColor, null, 0.5);
    }

    public ArrowEdgePortrayal3D(Color color, Color labelColor) {
        this(ArrowEdgePortrayal3D.appearanceForColor(color), labelColor, null, 0.5);
    }

    public ArrowEdgePortrayal3D(Image image, Color labelColor) {
        this(ArrowEdgePortrayal3D.appearanceForImage(image, true), labelColor, null, 0.5);
    }

    public ArrowEdgePortrayal3D(Appearance appearance, Color labelColor, Font labelFont, double radius) {
        super((Node)new Arrow(radius, dummyFrom, dummyTo, null, null, appearance), appearance, labelColor, labelFont);
    }

    protected int numShapes() {
        return 5;
    }

    protected Shape3D getShape(TransformGroup j3dModel, int shapeIndex) {
        TransformGroup endPointTG = (TransformGroup)j3dModel.getChild(0);
        TransformGroup edgeModelClone = (TransformGroup)endPointTG.getChild(0);
        int coneOffset = 3;
        if (shapeIndex < coneOffset) {
            TransformGroup arrowBody = (TransformGroup)edgeModelClone.getChild(0);
            Cylinder c = (Cylinder)arrowBody.getChild(0);
            return c.getShape(shapeIndex);
        }
        TransformGroup arrowHead = (TransformGroup)edgeModelClone.getChild(1);
        Cone c = (Cone)arrowHead.getChild(0);
        return c.getShape(shapeIndex - coneOffset);
    }

    protected void init(Node edgeModel) {
        super.init(edgeModel);
        Arrow arrow = (Arrow)edgeModel;
        arrow.setCapability(12);
        ((TransformGroup)arrow.getChild(0)).setCapability(12);
        ((TransformGroup)arrow.getChild(1)).setCapability(12);
        Cylinder body = arrow.getArrowTail();
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(0));
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(1));
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(2));
        Cone head = arrow.getArrowHead();
        PrimitivePortrayal3D.setShape3DFlags(head.getShape(0));
        PrimitivePortrayal3D.setShape3DFlags(head.getShape(1));
    }
}

