/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.network.SimpleEdgePortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.util.Bag;

public class NetworkPortrayal3D
extends FieldPortrayal3D {
    SimpleEdgePortrayal3D defaultPortrayal = new SimpleEdgePortrayal3D();

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public void setField(Object field) {
        if (!(field instanceof SpatialNetwork3D)) {
            throw new RuntimeException("Invalid field for FieldPortrayal3D: " + field + ".  You probably wanted a SpatialNetwork3D.");
        }
        super.setField(field);
    }

    public Object getField() {
        return this.field;
    }

    public TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        globalTG.setCapability(13);
        globalTG.setCapability(14);
        SpatialNetwork3D field = (SpatialNetwork3D)this.field;
        if (field == null) {
            return globalTG;
        }
        Bag nodes = field.network.getAllNodes();
        for (int x = 0; x < nodes.numObjs; ++x) {
            Bag edges = field.network.getEdgesOut(nodes.objs[x]);
            for (int y = 0; y < edges.numObjs; ++y) {
                Edge edge = (Edge)edges.objs[y];
                globalTG.addChild((Node)this.wrapModelForNewEdge(edge));
            }
        }
        return globalTG;
    }

    protected BranchGroup wrapModelForNewEdge(Edge edge) {
        LocationWrapper newwrapper = new LocationWrapper(edge.info, edge, this);
        Portrayal p = this.getPortrayalForObject(newwrapper);
        if (!(p instanceof SimpleEdgePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + edge + " -- expected a SimpleEdgePortrayal3D");
        }
        SimpleEdgePortrayal3D portrayal = (SimpleEdgePortrayal3D)p;
        portrayal.setCurrentFieldPortrayal(this);
        TransformGroup localTG = portrayal.getModel(newwrapper, null);
        localTG.setCapability(12);
        localTG.setUserData((Object)newwrapper);
        BranchGroup localBG = new BranchGroup();
        localBG.setCapability(12);
        localBG.setCapability(17);
        localBG.addChild((Node)localTG);
        localBG.setUserData((Object)newwrapper);
        return localBG;
    }

    public void updateModel(TransformGroup globalTG) {
        Object edge;
        SpatialNetwork3D field = (SpatialNetwork3D)this.field;
        if (field == null) {
            return;
        }
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        Network net = field.network;
        Bag nodes = net.getAllNodes();
        for (int n = 0; n < nodes.numObjs; ++n) {
            Bag edges = net.getEdgesOut(nodes.objs[n]);
            for (int i = 0; i < edges.numObjs; ++i) {
                edge = edges.objs[i];
                hm.put(edge, edge);
            }
        }
        for (int t = globalTG.numChildren() - 1; t >= 0; --t) {
            BranchGroup localBG = (BranchGroup)globalTG.getChild(t);
            LocationWrapper wrapper = (LocationWrapper)localBG.getUserData();
            edge = wrapper.getLocation();
            if (hm.remove(edge) != null) {
                TransformGroup localTG = (TransformGroup)localBG.getChild(0);
                Portrayal p = this.getPortrayalForObject(wrapper);
                if (!(p instanceof SimplePortrayal3D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + wrapper + " -- expecting a SimplePortrayal3D");
                }
                SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                p3d.setCurrentFieldPortrayal(this);
                TransformGroup localTG2 = p3d.getModel(wrapper, localTG);
                if (localTG == localTG2) continue;
                localTG2.setCapability(18);
                localTG2.setCapability(17);
                localTG2.setUserData((Object)wrapper);
                BranchGroup newlocalBG = new BranchGroup();
                newlocalBG.setCapability(12);
                newlocalBG.setCapability(17);
                newlocalBG.setUserData((Object)wrapper);
                newlocalBG.addChild((Node)localTG2);
                globalTG.setChild((Node)newlocalBG, t);
                continue;
            }
            globalTG.removeChild(t);
        }
        if (!hm.isEmpty()) {
            Iterator newObjs = hm.values().iterator();
            while (newObjs.hasNext()) {
                Edge edge2 = (Edge)newObjs.next();
                globalTG.addChild((Node)this.wrapModelForNewEdge(edge2));
            }
        }
    }

    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        return w;
    }
}

