/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import java.awt.Color;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.Font3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import sim.portrayal3d.SimplePortrayal3D;
import sim.util.Double3D;

public class Arrow
extends TransformGroup {
    static final Color DEFAULT_ARROW_COLOR = Color.gray;
    static final Font3D DEFAULT_FONT3D = new Font3D(new Font(null, 0, 1), null);
    Cone arrowHead;
    Cylinder arrowTail;

    public Cylinder getArrowTail() {
        return this.arrowTail;
    }

    public Cone getArrowHead() {
        return this.arrowHead;
    }

    public Arrow(double arrowTailRadius, Double3D startPoint, Double3D endPoint, String stLabel, String endLabel, Appearance appearance) {
        Transform3D t;
        OrientedShape3D os3d;
        Text3D txt;
        Appearance caAppearance;
        Vector3d stPt = new Vector3d(startPoint.x, startPoint.y, startPoint.z);
        Vector3d endPt = new Vector3d(endPoint.x, endPoint.y, endPoint.z);
        Vector3d v = new Vector3d(stPt);
        v.negate();
        v.add((Tuple3d)new Vector3d(endPt));
        float arrowLen = (float)v.length();
        float arrowHeadLen = 5.0f * (float)arrowTailRadius;
        float arrowHeadMaxRadius = 3.0f * (float)arrowTailRadius;
        float cylinderLen = arrowLen - arrowHeadLen;
        if (cylinderLen < 0.0f) {
            arrowHeadLen = arrowLen / 16.0f;
            cylinderLen = arrowLen - arrowHeadLen;
        }
        if ((caAppearance = appearance) == null) {
            caAppearance = SimplePortrayal3D.appearanceForColors(DEFAULT_ARROW_COLOR, null, DEFAULT_ARROW_COLOR, DEFAULT_ARROW_COLOR, 1.0, 1.0);
        }
        Transform3D caTransform = new Transform3D();
        caTransform.setTranslation(stPt);
        Vector3d oy = new Vector3d(0.0, 1.0, 0.0);
        Vector3d axis = new Vector3d();
        axis.cross(oy, v);
        if (axis.length() != 0.0) {
            caTransform.setRotation(new AxisAngle4d(axis, Math.asin(axis.length() / v.length())));
        }
        caTransform.setTranslation(stPt);
        this.setTransform(caTransform);
        this.arrowTail = new Cylinder((float)arrowTailRadius, cylinderLen, caAppearance);
        Transform3D arrowCylinderTransform = new Transform3D();
        arrowCylinderTransform.set(new Vector3f(0.0f, cylinderLen / 2.0f, 0.0f));
        TransformGroup arrowCylinderTransformGroup = new TransformGroup(arrowCylinderTransform);
        arrowCylinderTransformGroup.addChild((Node)this.arrowTail);
        this.addChild((Node)arrowCylinderTransformGroup);
        Transform3D arrowHeadTransform = new Transform3D();
        arrowHeadTransform.set(new Vector3f(0.0f, cylinderLen, 0.0f));
        TransformGroup arrowHeadTransformGroup = new TransformGroup(arrowHeadTransform);
        this.arrowHead = new Cone(arrowHeadMaxRadius, arrowHeadLen, 1, caAppearance);
        arrowHeadTransformGroup.addChild((Node)this.arrowHead);
        this.addChild((Node)arrowHeadTransformGroup);
        if (stLabel != null) {
            txt = new Text3D(DEFAULT_FONT3D, stLabel);
            os3d = new OrientedShape3D((Geometry)txt, caAppearance, 1, new Point3f(0.0f, 0.0f, 0.0f));
            t = new Transform3D();
            t.setScale((double)(5.0f * (float)arrowTailRadius));
            t.setTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
            TransformGroup stLabelTG = new TransformGroup(t);
            stLabelTG.addChild((Node)os3d);
            this.addChild((Node)stLabelTG);
        }
        if (endLabel != null) {
            txt = new Text3D(DEFAULT_FONT3D, endLabel);
            os3d = new OrientedShape3D((Geometry)txt, caAppearance, 1, new Point3f(0.0f, arrowLen, 0.0f));
            t = new Transform3D();
            t.setScale((double)(5.0f * (float)arrowTailRadius));
            t.setTranslation(new Vector3f(0.0f, arrowLen + 0.1f, 0.0f));
            TransformGroup endLabelTG = new TransformGroup(t);
            endLabelTG.addChild((Node)os3d);
            this.addChild((Node)endLabelTG);
        }
    }
}

