/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.Int3D;
import sim.util.MutableDouble2D;
import sim.util.MutableDouble3D;
import sim.util.MutableInt2D;
import sim.util.MutableInt3D;

public final class Double3D
implements Serializable {
    public final double x;
    public final double y;
    public final double z;

    public Double3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Double3D(Int2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0.0;
    }

    public Double3D(Int2D p, double z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public Double3D(Int3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Double3D(MutableInt2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0.0;
    }

    public Double3D(MutableInt2D p, double z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public Double3D(MutableInt3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Double3D(Double2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0.0;
    }

    public Double3D(Double2D p, double z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public Double3D(Double3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Double3D(MutableDouble2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0.0;
    }

    public Double3D(MutableDouble2D p, double z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public Double3D(MutableDouble3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Double3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public String toString() {
        return "Double3D[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public String toCoordinates() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public int hashCode() {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        if (z == -0.0) {
            z = 0.0;
        }
        if ((double)((int)x) == x && (double)((int)y) == y && (double)((int)z) == z) {
            int y_ = (int)y;
            int x_ = (int)x;
            int z_ = (int)z;
            z_ += ~(z_ << 15);
            z_ ^= z_ >>> 10;
            z_ += z_ << 3;
            z_ ^= z_ >>> 6;
            z_ += ~(z_ << 11);
            z_ ^= z_ >>> 16;
            z_ ^= y_;
            z_ += 17;
            z_ += ~(z_ << 15);
            z_ ^= z_ >>> 10;
            z_ += z_ << 3;
            z_ ^= z_ >>> 6;
            z_ += ~(z_ << 11);
            z_ ^= z_ >>> 16;
            return x_ ^ z_;
        }
        long key = Double.doubleToLongBits(z);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        key ^= Double.doubleToLongBits(y);
        key += 17L;
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        return (int)((key ^= Double.doubleToLongBits(x)) ^ key >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double3D) {
            Double3D other = (Double3D)obj;
            return (this.x == other.x || Double.isNaN(this.x) && Double.isNaN(other.x)) && (this.y == other.y || Double.isNaN(this.y) && Double.isNaN(other.y)) && (this.z == other.z || Double.isNaN(this.z) && Double.isNaN(other.z));
        }
        if (obj instanceof MutableDouble3D) {
            MutableDouble3D other = (MutableDouble3D)obj;
            return (this.x == other.x || Double.isNaN(this.x) && Double.isNaN(other.x)) && (this.y == other.y || Double.isNaN(this.y) && Double.isNaN(other.y)) && (this.z == other.z || Double.isNaN(this.z) && Double.isNaN(other.z));
        }
        if (obj instanceof Int3D) {
            Int3D other = (Int3D)obj;
            return (double)other.x == this.x && (double)other.y == this.y && (double)other.z == this.z;
        }
        if (obj instanceof MutableInt3D) {
            MutableInt3D other = (MutableInt3D)obj;
            return (double)other.x == this.x && (double)other.y == this.y && (double)other.z == this.z;
        }
        return false;
    }

    public double distance(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(Double3D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        double dz = this.z - p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(Int3D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        double dz = this.z - (double)p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(MutableInt3D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        double dz = this.z - (double)p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSq(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(Double3D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        double dz = this.z - p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(Int3D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        double dz = this.z - (double)p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(MutableInt3D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        double dz = this.z - (double)p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double manhattanDistance(double x, double y, double z) {
        double dx = Math.abs(this.x - x);
        double dy = Math.abs(this.y - y);
        double dz = Math.abs(this.z - z);
        return dx + dy + dz;
    }

    public double manhattanDistance(Double3D p) {
        double dx = Math.abs(this.x - p.x);
        double dy = Math.abs(this.y - p.y);
        double dz = Math.abs(this.z - p.z);
        return dx + dy + dz;
    }

    public double manhattanDistance(Int3D p) {
        double dx = Math.abs(this.x - (double)p.x);
        double dy = Math.abs(this.y - (double)p.y);
        double dz = Math.abs(this.z - (double)p.z);
        return dx + dy + dz;
    }

    public double manhattanDistance(MutableDouble3D p) {
        double dx = Math.abs(this.x - p.x);
        double dy = Math.abs(this.y - p.y);
        double dz = Math.abs(this.z - p.z);
        return dx + dy + dz;
    }

    public double manhattanDistance(MutableInt3D p) {
        double dx = Math.abs(this.x - (double)p.x);
        double dy = Math.abs(this.y - (double)p.y);
        double dz = Math.abs(this.z - (double)p.z);
        return dx + dy + dz;
    }
}

